/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import org.jppf.server.nio.ChannelSelector;
import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.NioServer;
import org.jppf.utils.ThreadSynchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelSelectorThread
extends ThreadSynchronization
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(ChannelSelectorThread.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private ChannelSelector selector = null;
    private NioServer<?, ?> server = null;

    public ChannelSelectorThread(ChannelSelector selector, NioServer<?, ?> server) {
        this.selector = selector;
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isStopped()) {
            ChannelWrapper channel;
            if (!this.selector.select()) continue;
            ChannelWrapper channelWrapper = channel = this.selector.getChannel();
            synchronized (channelWrapper) {
                if (debugEnabled) {
                    log.debug("selected channel " + channel);
                }
                this.server.getTransitionManager().submitTransition(channel);
            }
            this.server.postSelect();
        }
    }

    public void close() {
        this.setStopped(true);
        this.selector.wakeUp();
    }
}

