/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import java.util.concurrent.locks.ReentrantLock;
import org.jppf.server.nio.ChannelSelector;
import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.NioServer;
import org.jppf.utils.ThreadSynchronization;

public class LocalChannelSelector
extends ThreadSynchronization
implements ChannelSelector {
    private ChannelWrapper<?> channel = null;
    private NioServer<?, ?> server = null;
    private ReentrantLock lock = new ReentrantLock();

    public LocalChannelSelector(ChannelWrapper<?> channel, NioServer<?, ?> server) {
        this.channel = channel;
        this.server = server;
    }

    public boolean select() {
        return this.select(0L);
    }

    public boolean select(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must be >= 0");
        }
        long start = System.currentTimeMillis();
        long elapsed = 0L;
        boolean selected = this.channelSelected();
        while (!(timeout != 0L && elapsed >= timeout || selected)) {
            this.goToSleep(timeout == 0L ? 0L : timeout - elapsed);
            elapsed = System.currentTimeMillis() - start;
            selected = this.channelSelected();
        }
        return selected;
    }

    public boolean selectNow() {
        return (this.channel.getKeyOps() & this.channel.getReadyOps()) != 0;
    }

    public ChannelWrapper<?> getChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean channelSelected() {
        ChannelWrapper<?> channelWrapper = this.channel;
        synchronized (channelWrapper) {
            return (this.channel.getKeyOps() & this.channel.getReadyOps()) != 0;
        }
    }
}

