/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import org.jppf.io.DataLocation;
import org.jppf.io.InputSource;
import org.jppf.io.MultipleBuffersLocation;
import org.jppf.io.OutputDestination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NioObject {
    private static Logger log = LoggerFactory.getLogger(NioObject.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private int size = 0;
    private int count = 0;
    private DataLocation data = null;
    private boolean blocking = false;

    public NioObject(int size, boolean blocking) {
        this(new MultipleBuffersLocation(size), blocking);
    }

    public NioObject(DataLocation data, boolean blocking) {
        this.size = data.getSize();
        this.data = data;
    }

    public boolean read(InputSource source) throws Exception {
        if (this.count >= this.size) {
            return true;
        }
        int n = this.data.transferFrom(source, this.blocking);
        if (n > 0) {
            this.count += n;
        }
        if (debugEnabled) {
            log.debug("read " + n + " bytes from input source, count/size = " + this.count + "/" + this.size);
        }
        if (this.count >= this.size) {
            if (debugEnabled) {
                log.debug("count = " + this.count + ", size = " + this.size);
            }
            return true;
        }
        return false;
    }

    public boolean write(OutputDestination dest) throws Exception {
        if (this.count >= this.size) {
            return true;
        }
        int n = this.data.transferTo(dest, this.blocking);
        if (n > 0) {
            this.count += n;
        }
        if (debugEnabled) {
            log.debug("wrote " + n + " bytes to output destination, count/size = " + this.count + "/" + this.size + " (dl = " + this.data + ")");
        }
        if (this.count > this.size) {
            boolean bl = false;
        }
        return this.count >= this.size;
    }

    public DataLocation getData() {
        return this.data;
    }

    public int getCount() {
        return this.count;
    }
}

