/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.jppf.JPPFException;
import org.jppf.classloader.ResourceProvider;
import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.NioContext;
import org.jppf.server.nio.NioServerFactory;
import org.jppf.server.nio.SelectionKeyWrapper;
import org.jppf.server.nio.StateTransitionManager;
import org.jppf.utils.JPPFConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NioServer<S extends Enum<S>, T extends Enum<T>>
extends Thread {
    private static Logger log = LoggerFactory.getLogger(NioServer.class);
    private static final int THREAD_POOL_SIZE = JPPFConfiguration.getProperties().getInt("transition.thread.pool.size", 1);
    protected Selector selector;
    protected ResourceProvider resourceProvider = new ResourceProvider();
    private AtomicBoolean stopped = new AtomicBoolean(false);
    protected int[] ports = null;
    protected long selectTimeout = 0L;
    protected NioServerFactory<S, T> factory = null;
    protected ReentrantLock lock = new ReentrantLock();
    protected StateTransitionManager<S, T> transitionManager = null;

    protected NioServer(String name) throws JPPFException {
        this(name, false);
    }

    protected NioServer(String name, boolean sequential) throws JPPFException {
        super(name);
        this.factory = this.createFactory();
        this.transitionManager = new StateTransitionManager(this, sequential);
    }

    public NioServer(int port, String name) throws JPPFException {
        this(new int[]{port}, name, true);
    }

    public NioServer(int[] ports, String name, boolean sequential) throws JPPFException {
        this(name, sequential);
        this.ports = new int[ports.length];
        System.arraycopy(ports, 0, this.ports, 0, ports.length);
        this.init(ports);
    }

    protected abstract NioServerFactory<S, T> createFactory();

    protected final void init(int[] ports) throws JPPFException {
        Exception e = null;
        try {
            this.selector = Selector.open();
            for (int port : ports) {
                ServerSocketChannel server = ServerSocketChannel.open();
                server.socket().setReceiveBufferSize(65536);
                server.socket().bind(new InetSocketAddress(port));
                server.configureBlocking(false);
                server.register(this.selector, 16);
            }
        }
        catch (IllegalArgumentException iae) {
            e = iae;
        }
        catch (IOException ioe) {
            e = ioe;
        }
        if (e != null) {
            throw new JPPFException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            boolean hasTimeout;
            boolean bl = hasTimeout = this.selectTimeout > 0L;
            while (!this.isStopped() && !this.externalStopCondition()) {
                int n;
                try {
                    this.lock.lock();
                }
                finally {
                    this.lock.unlock();
                }
                int n2 = n = hasTimeout ? this.selector.select(this.selectTimeout) : this.selector.select();
                if (n > 0) {
                    this.go(this.selector.selectedKeys());
                }
                this.postSelect();
            }
            this.end();
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
            this.end();
        }
    }

    protected boolean externalStopCondition() {
        return false;
    }

    public void go(Set<SelectionKey> selectedKeys) throws Exception {
        Iterator<SelectionKey> it = selectedKeys.iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            it.remove();
            try {
                if (!key.isValid()) continue;
                if (key.isAcceptable()) {
                    this.doAccept(key);
                    continue;
                }
                NioContext context = (NioContext)key.attachment();
                this.transitionManager.submitTransition(context.getChannel());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                if (key.channel() instanceof ServerSocketChannel) continue;
                try {
                    key.channel().close();
                }
                catch (Exception e2) {
                    log.error(e2.getMessage(), (Throwable)e2);
                }
            }
        }
    }

    public void postSelect() {
    }

    private void doAccept(SelectionKey key) {
        SocketChannel channel;
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)key.channel();
        try {
            channel = serverSocketChannel.accept();
        }
        catch (IOException ignored) {
            log.error(ignored.getMessage(), (Throwable)ignored);
            return;
        }
        if (channel == null) {
            return;
        }
        try {
            channel.socket().setSendBufferSize(65536);
            channel.configureBlocking(false);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            try {
                channel.close();
            }
            catch (IOException ignored) {
                log.error(ignored.getMessage(), (Throwable)ignored);
            }
            return;
        }
        NioContext context = this.createNioContext();
        try {
            SelectionKey selKey = channel.register(this.selector, this.getInitialInterest(), context);
            SelectionKeyWrapper wrapper = new SelectionKeyWrapper(selKey);
            context.setChannel((ChannelWrapper)wrapper);
            this.postAccept((ChannelWrapper)wrapper, serverSocketChannel);
        }
        catch (ClosedChannelException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void postAccept(ChannelWrapper key, ServerSocketChannel serverChannel) {
        this.postAccept(key);
    }

    public abstract void postAccept(ChannelWrapper var1);

    public abstract NioContext createNioContext();

    public abstract int getInitialInterest();

    public void end() {
        if (!this.isStopped()) {
            this.setStopped(true);
            this.removeAllConnections();
        }
    }

    public void removeAllConnections() {
        if (!this.isStopped()) {
            return;
        }
        try {
            this.selector.wakeup();
            Set<SelectionKey> keySet = this.selector.keys();
            for (SelectionKey key : keySet) {
                key.channel().close();
                key.cancel();
            }
            this.selector.close();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public Selector getSelector() {
        return this.selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NioServerFactory<S, T> getFactory() {
        NioServer nioServer = this;
        synchronized (nioServer) {
            if (this.factory == null) {
                this.factory = this.createFactory();
            }
        }
        return this.factory;
    }

    public ReentrantLock getLock() {
        return this.lock;
    }

    protected void setStopped(boolean stopped) {
        this.stopped.set(stopped);
    }

    protected boolean isStopped() {
        return this.stopped.get();
    }

    public StateTransitionManager<S, T> getTransitionManager() {
        return this.transitionManager;
    }

    public int[] getPorts() {
        return this.ports;
    }
}

