/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import org.jppf.server.nio.AbstractChannelWrapper;
import org.jppf.server.nio.NioContext;
import org.jppf.utils.StringUtils;

public class SelectionKeyWrapper
extends AbstractChannelWrapper<SelectionKey> {
    public SelectionKeyWrapper(SelectionKey channel) {
        super((Object)channel);
    }

    public NioContext getContext() {
        return (NioContext)((SelectionKey)this.getChannel()).attachment();
    }

    public void close() throws Exception {
        ((SelectionKey)this.getChannel()).channel().close();
    }

    public boolean isOpen() {
        return ((SelectionKey)this.getChannel()).channel().isOpen();
    }

    public String toString() {
        SelectableChannel ch = ((SelectionKey)this.getChannel()).channel();
        if (((SelectionKey)this.channel).isValid()) {
            return super.toString();
        }
        return "[invalid channel]";
    }

    public String getId() {
        return StringUtils.getRemoteHost((Channel)((SelectionKey)this.getChannel()).channel());
    }

    public int getKeyOps() {
        return ((SelectionKey)this.getChannel()).interestOps();
    }

    public void setKeyOps(int keyOps) {
        SelectionKey key = (SelectionKey)this.channel;
        key.selector().wakeup();
        ((SelectionKey)this.channel).interestOps(keyOps);
    }

    public int getReadyOps() {
        return ((SelectionKey)this.getChannel()).readyOps();
    }
}

