/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import org.jppf.server.nio.AbstractNioContext;
import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.NioMessage;
import org.jppf.server.nio.SelectionKeyWrapper;
import org.jppf.utils.SerializationUtils;
import org.jppf.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleNioContext<S extends Enum<S>>
extends AbstractNioContext<S> {
    private static Logger log = LoggerFactory.getLogger(SimpleNioContext.class);
    private static boolean traceEnabled = log.isTraceEnabled();

    public boolean readMessage(ChannelWrapper<?> wrapper) throws Exception {
        ReadableByteChannel channel = (ReadableByteChannel)((Object)((SelectionKey)((SelectionKeyWrapper)wrapper).getChannel()).channel());
        if (this.message == null) {
            this.message = new NioMessage();
        }
        if (this.message.length <= 0) {
            this.message.length = SerializationUtils.readInt((ReadableByteChannel)channel);
            this.message.buffer = ByteBuffer.allocate(this.message.length);
            this.readByteCount = 0;
        }
        this.readByteCount += channel.read(this.message.buffer);
        if (traceEnabled) {
            log.trace("[" + this.getShortClassName() + "] " + "read " + this.readByteCount + " bytes out of " + this.message.length + " for " + StringUtils.getRemoteHost((Channel)((SocketChannel)channel)));
        }
        return this.readByteCount >= this.message.length;
    }

    public boolean writeMessage(ChannelWrapper<?> wrapper) throws Exception {
        WritableByteChannel channel = (WritableByteChannel)((Object)((SelectionKey)((SelectionKeyWrapper)wrapper).getChannel()).channel());
        if (!this.message.lengthWritten) {
            SerializationUtils.writeInt((WritableByteChannel)channel, (int)this.message.length);
            this.message.lengthWritten = true;
            this.writeByteCount = 0;
        }
        this.writeByteCount += channel.write(this.message.buffer);
        if (traceEnabled) {
            log.trace("[" + this.getShortClassName() + "] " + "written " + this.writeByteCount + " bytes out of " + this.message.length + " for " + StringUtils.getRemoteHost((Channel)((SelectableChannel)((Object)channel))));
        }
        return this.writeByteCount >= this.message.length;
    }
}

