/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReentrantLock;
import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.NioContext;
import org.jppf.server.nio.NioServer;
import org.jppf.server.nio.NioTransition;
import org.jppf.server.nio.SelectionKeyWrapper;
import org.jppf.server.nio.StateTransitionTask;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.JPPFThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateTransitionManager<S extends Enum<S>, T extends Enum<T>> {
    private static Logger log = LoggerFactory.getLogger(StateTransitionManager.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    protected ExecutorService executor = null;
    private NioServer<S, T> server = null;
    private boolean sequential = false;

    public StateTransitionManager(NioServer<S, T> server, boolean sequential) {
        this.server = server;
        this.sequential = sequential;
        int size = JPPFConfiguration.getProperties().getInt("transition.thread.pool.size", -1);
        if (size <= 0) {
            size = Runtime.getRuntime().availableProcessors();
        }
        if (!sequential) {
            this.executor = Executors.newFixedThreadPool(size, (ThreadFactory)new JPPFThreadFactory(server.getName()));
        }
    }

    protected void submitTransition(ChannelWrapper<?> key) {
        if (debugEnabled) {
            log.debug("submitting transition for " + key);
        }
        this.setKeyOps(key, 0);
        StateTransitionTask<S, T> transition = new StateTransitionTask<S, T>(key, this.server.getFactory());
        if (this.sequential) {
            transition.run();
        } else {
            this.executor.submit(transition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setKeyOps(ChannelWrapper<?> key, int ops) {
        ReentrantLock lock = this.server.getLock();
        lock.lock();
        try {
            this.server.getSelector().wakeup();
            key.setKeyOps(ops);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transitionChannel(ChannelWrapper<?> channel, T transition) {
        this.server.getLock().lock();
        try {
            NioContext context = channel.getContext();
            Enum s1 = context.getState();
            NioTransition<S> t = this.server.getFactory().getTransition(transition);
            S s2 = t.getState();
            context.setState(s2);
            channel.setKeyOps(t.getInterestOps());
            if (debugEnabled && s1 != s2) {
                log.debug("transitionned " + channel + " from " + s1 + " to " + s2);
            }
        }
        finally {
            this.server.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelWrapper<?> registerChannel(SocketChannel channel, int ops, NioContext context, ChannelRegistrationAction action) {
        SelectionKeyWrapper wrapper = null;
        SelectionKey key = null;
        try {
            this.server.getLock().lock();
            try {
                this.server.getSelector().wakeup();
                key = channel.register(this.server.getSelector(), ops, context);
                wrapper = new SelectionKeyWrapper(key);
                if (action != null) {
                    action.key = wrapper;
                    action.run();
                }
            }
            finally {
                this.server.getLock().unlock();
            }
        }
        catch (ClosedChannelException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return wrapper;
    }

    public void submit(Runnable r) {
        r.run();
    }

    public boolean isSequential() {
        return this.sequential;
    }

    public static abstract class ChannelRegistrationAction
    implements Runnable {
        public ChannelWrapper<?> key = null;
    }
}

