/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio;

import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.NioContext;
import org.jppf.server.nio.NioServerFactory;
import org.jppf.server.nio.NioState;
import org.jppf.server.nio.StateTransitionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateTransitionTask<S extends Enum<S>, T extends Enum<T>>
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(StateTransitionTask.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static boolean traceEnabled = log.isTraceEnabled();
    private ChannelWrapper<?> channel = null;
    private NioContext<S> ctx = null;
    private NioServerFactory<S, T> factory = null;

    public StateTransitionTask(ChannelWrapper<?> channel, NioServerFactory<S, T> factory) {
        this.channel = channel;
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ChannelWrapper<?> channelWrapper = this.channel;
        synchronized (channelWrapper) {
            StateTransitionManager<S, T> transitionManager = this.factory.getServer().getTransitionManager();
            this.ctx = this.channel.getContext();
            if (traceEnabled) {
                log.trace("performing transition to state " + this.ctx.getState() + " for " + this.channel);
            }
            try {
                NioState<T> state = this.factory.getState(this.ctx.getState());
                transitionManager.transitionChannel(this.channel, state.performTransition(this.channel));
            }
            catch (Exception e) {
                if (debugEnabled) {
                    log.debug(e.getMessage(), (Throwable)e);
                } else {
                    log.warn(e.getMessage());
                }
                this.ctx.handleException(this.channel);
            }
        }
    }
}

