/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer;

import java.io.IOException;
import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.multiplexer.MultiplexerChannelInitializer;
import org.jppf.server.nio.multiplexer.MultiplexerContext;
import org.jppf.server.nio.multiplexer.MultiplexerNioServer;
import org.jppf.server.nio.multiplexer.MultiplexerServerState;
import org.jppf.server.nio.multiplexer.MultiplexerTransition;
import org.jppf.server.nio.multiplexer.OutboundChannelHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifyingInboundChannelState
extends MultiplexerServerState {
    private static Logger log = LoggerFactory.getLogger(IdentifyingInboundChannelState.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public IdentifyingInboundChannelState(MultiplexerNioServer server) {
        super(server);
    }

    @Override
    public MultiplexerTransition performTransition(ChannelWrapper<?> wrapper) throws Exception {
        MultiplexerContext context = (MultiplexerContext)wrapper.getContext();
        if (debugEnabled) {
            log.debug("exec() for " + wrapper);
        }
        if (context.readMessage(wrapper)) {
            int port = context.readOutBoundPort();
            if (debugEnabled) {
                log.debug("read port number for " + wrapper + ": " + port);
            }
            if (port <= 0) {
                throw new IOException("outbound port could not be read from this channel");
            }
            OutboundChannelHandler handler = new OutboundChannelHandler(this.server, "localhost", port, wrapper);
            MultiplexerChannelInitializer init = new MultiplexerChannelInitializer(handler);
            context.setMessage(null);
            this.server.getTransitionManager().transitionChannel(wrapper, MultiplexerTransition.TO_IDLE);
            new Thread(init).start();
            return MultiplexerTransition.TO_IDLE;
        }
        return MultiplexerTransition.TO_IDENTIFYING_INBOUND_CHANNEL;
    }
}

