/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer;

import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.SimpleNioContext;
import org.jppf.server.nio.multiplexer.MultiplexerState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiplexerContext
extends SimpleNioContext<MultiplexerState> {
    private static Logger log = LoggerFactory.getLogger(MultiplexerContext.class);
    private ChannelWrapper linkedKey = null;
    private int boundPort = -1;
    private int multiplexerPort = -1;

    public void handleException(ChannelWrapper<?> channel) {
        try {
            if (this.linkedKey != null) {
                try {
                    this.linkedKey.close();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            channel.close();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized ChannelWrapper<?> getLinkedKey() {
        return this.linkedKey;
    }

    public synchronized void setLinkedKey(ChannelWrapper<?> key) {
        this.linkedKey = key;
    }

    public int getBoundPort() {
        return this.boundPort;
    }

    public void setBoundPort(int boundPort) {
        this.boundPort = boundPort;
    }

    public int getMultiplexerPort() {
        return this.multiplexerPort;
    }

    public void setMultiplexerPort(int multiplexerPort) {
        this.multiplexerPort = multiplexerPort;
    }

    public boolean isApplicationPort() {
        return this.boundPort > 0;
    }

    public boolean isMultiplexerPort() {
        return this.multiplexerPort > 0;
    }

    public int readOutBoundPort() {
        if (this.message == null) {
            return -1;
        }
        this.message.buffer.flip();
        return this.message.buffer.getInt();
    }
}

