/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer;

import java.nio.channels.Channel;
import java.nio.channels.SocketChannel;
import org.jppf.comm.socket.SocketChannelClient;
import org.jppf.server.nio.AbstractSocketChannelHandler;
import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.NioContext;
import org.jppf.server.nio.NioServer;
import org.jppf.server.nio.StateTransitionManager;
import org.jppf.server.nio.multiplexer.MultiplexerContext;
import org.jppf.server.nio.multiplexer.MultiplexerState;
import org.jppf.server.nio.multiplexer.MultiplexerTransition;
import org.jppf.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboundChannelHandler
extends AbstractSocketChannelHandler {
    private static Logger log = LoggerFactory.getLogger(OutboundChannelHandler.class);
    private boolean debugEnabled = log.isDebugEnabled();
    private ChannelWrapper initialKey = null;

    public OutboundChannelHandler(NioServer server, String host, int port, ChannelWrapper initialKey) {
        super(server, host, port);
        this.initialKey = initialKey;
    }

    @Override
    protected SocketChannelClient initSocketChannel() throws Exception {
        return new SocketChannelClient(this.host, this.port, false);
    }

    @Override
    protected void postInit() throws Exception {
        SocketChannel channel = this.socketClient.getChannel();
        this.socketClient.setChannel(null);
        MultiplexerContext context = (MultiplexerContext)this.server.createNioContext();
        context.setLinkedKey(this.initialKey);
        context.setState(MultiplexerState.SENDING_OR_RECEIVING);
        this.server.getTransitionManager().registerChannel(channel, 1, (NioContext)context, new StateTransitionManager.ChannelRegistrationAction(){

            @Override
            public void run() {
                MultiplexerContext initialContext = (MultiplexerContext)OutboundChannelHandler.this.initialKey.getContext();
                initialContext.setLinkedKey(this.key);
                OutboundChannelHandler.this.server.getTransitionManager().transitionChannel(OutboundChannelHandler.this.initialKey, MultiplexerTransition.TO_SENDING_OR_RECEIVING);
            }
        });
        if (this.debugEnabled) {
            log.debug("registered outbound channel " + StringUtils.getRemoteHost((Channel)channel));
        }
    }
}

