/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer;

import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.NioMessage;
import org.jppf.server.nio.multiplexer.MultiplexerContext;
import org.jppf.server.nio.multiplexer.MultiplexerNioServer;
import org.jppf.server.nio.multiplexer.MultiplexerServerState;
import org.jppf.server.nio.multiplexer.MultiplexerTransition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingState
extends MultiplexerServerState {
    private static Logger log = LoggerFactory.getLogger(ReceivingState.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public ReceivingState(MultiplexerNioServer server) {
        super(server);
    }

    @Override
    public MultiplexerTransition performTransition(ChannelWrapper<?> wrapper) throws Exception {
        MultiplexerContext context = (MultiplexerContext)wrapper.getContext();
        if (debugEnabled) {
            log.debug("exec() for " + wrapper);
        }
        if (context.readMessage(wrapper)) {
            if (debugEnabled) {
                log.debug("read message for " + wrapper + " done");
            }
            ChannelWrapper<?> linkedKey = context.getLinkedKey();
            NioMessage msg = context.getMessage();
            msg.buffer.flip();
            context.setMessage(null);
            MultiplexerContext linkedContext = (MultiplexerContext)linkedKey.getContext();
            linkedContext.setMessage(msg);
            this.server.getTransitionManager().transitionChannel(linkedKey, MultiplexerTransition.TO_SENDING);
            return MultiplexerTransition.TO_SENDING_OR_RECEIVING;
        }
        return MultiplexerTransition.TO_RECEIVING;
    }
}

