/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer;

import java.net.ConnectException;
import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.multiplexer.MultiplexerContext;
import org.jppf.server.nio.multiplexer.MultiplexerNioServer;
import org.jppf.server.nio.multiplexer.MultiplexerServerState;
import org.jppf.server.nio.multiplexer.MultiplexerTransition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingState
extends MultiplexerServerState {
    private static Logger log = LoggerFactory.getLogger(SendingState.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public SendingState(MultiplexerNioServer server) {
        super(server);
    }

    @Override
    public MultiplexerTransition performTransition(ChannelWrapper<?> wrapper) throws Exception {
        if (wrapper.isReadable()) {
            throw new ConnectException("multiplexer " + wrapper + " has been disconnected");
        }
        MultiplexerContext context = (MultiplexerContext)wrapper.getContext();
        if (context.writeMessage(wrapper)) {
            if (debugEnabled) {
                log.debug(wrapper.toString() + " message sent");
            }
            context.setMessage(null);
            return MultiplexerTransition.TO_SENDING_OR_RECEIVING;
        }
        return MultiplexerTransition.TO_SENDING;
    }
}

