/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer.generic;

import java.nio.channels.SocketChannel;
import org.jppf.comm.socket.SocketChannelClient;
import org.jppf.server.nio.AbstractSocketChannelHandler;
import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.NioContext;
import org.jppf.server.nio.NioServer;
import org.jppf.server.nio.StateTransitionManager;
import org.jppf.server.nio.multiplexer.generic.MultiplexerContext;
import org.jppf.server.nio.multiplexer.generic.MultiplexerState;
import org.jppf.server.nio.multiplexer.generic.MultiplexerTransition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiplexerChannelHandler
extends AbstractSocketChannelHandler {
    private static Logger log = LoggerFactory.getLogger(MultiplexerChannelHandler.class);
    private boolean debugEnabled = log.isDebugEnabled();
    private ChannelWrapper initialKey = null;

    public MultiplexerChannelHandler(NioServer server, String host, int port, ChannelWrapper initialKey) {
        super(server, host, port);
        this.initialKey = initialKey;
    }

    @Override
    protected SocketChannelClient initSocketChannel() throws Exception {
        return new SocketChannelClient(this.host, this.port, false);
    }

    @Override
    protected void postInit() throws Exception {
        SocketChannel channel = this.socketClient.getChannel();
        this.socketClient.setChannel(null);
        MultiplexerContext context = (MultiplexerContext)this.server.createNioContext();
        context.setLinkedKey(this.initialKey);
        context.setState(MultiplexerState.SENDING_MULTIPLEXING_INFO);
        this.server.getTransitionManager().registerChannel(channel, 5, (NioContext)context, new StateTransitionManager.ChannelRegistrationAction(){

            @Override
            public void run() {
                MultiplexerContext initialContext = (MultiplexerContext)MultiplexerChannelHandler.this.initialKey.getContext();
                initialContext.setLinkedKey(this.key);
                MultiplexerChannelHandler.this.server.getTransitionManager().transitionChannel(MultiplexerChannelHandler.this.initialKey, MultiplexerTransition.TO_SENDING_OR_RECEIVING);
            }
        });
        if (this.debugEnabled) {
            log.debug("registered multiplexer channel");
        }
    }
}

