/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer.generic;

import java.nio.channels.ServerSocketChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jppf.JPPFException;
import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.NioContext;
import org.jppf.server.nio.NioServer;
import org.jppf.server.nio.NioServerFactory;
import org.jppf.server.nio.multiplexer.generic.MultiplexerChannelHandler;
import org.jppf.server.nio.multiplexer.generic.MultiplexerChannelInitializer;
import org.jppf.server.nio.multiplexer.generic.MultiplexerContext;
import org.jppf.server.nio.multiplexer.generic.MultiplexerServerFactory;
import org.jppf.server.nio.multiplexer.generic.MultiplexerState;
import org.jppf.server.nio.multiplexer.generic.MultiplexerTransition;
import org.jppf.utils.HostPort;
import org.jppf.utils.JPPFConfiguration;
import org.jppf.utils.StringUtils;
import org.jppf.utils.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiplexerNioServer
extends NioServer<MultiplexerState, MultiplexerTransition> {
    private static final String THIS_NAME = "MultiplexerServer Thread";
    private static Logger log = LoggerFactory.getLogger(MultiplexerNioServer.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private Set<String> remoteMultiplexers = new HashSet<String>();
    private Map<String, HostPort> remoteMultiplexerMap = new HashMap<String, HostPort>();
    private Set<Integer> boundPorts = new HashSet<Integer>();
    private Map<Integer, String> boundToMultiplexerMap = new HashMap<Integer, String>();
    private Set<Integer> multiplexerPorts = new HashSet<Integer>();

    public MultiplexerNioServer() throws JPPFException {
        super(THIS_NAME);
        this.selectTimeout = 1L;
        this.configure();
    }

    @Override
    protected NioServerFactory<MultiplexerState, MultiplexerTransition> createFactory() {
        return new MultiplexerServerFactory(this);
    }

    private void configure() throws JPPFException {
        TypedProperties props;
        String s;
        if (debugEnabled) {
            log.debug("configuring the multiplexer");
        }
        if ((s = (props = JPPFConfiguration.getProperties()).getString("multiplexer.ports")) != null) {
            int[] ports;
            for (int port : ports = StringUtils.parseIntValues((String)s)) {
                this.multiplexerPorts.add(port);
            }
        }
        if ((s = props.getString("remote.multiplexers")) != null) {
            String[] names;
            for (String name : names = s.split("\\s")) {
                this.remoteMultiplexers.add(name);
                s = props.getString("remote.multiplexer." + name);
                if (s == null) continue;
                this.remoteMultiplexerMap.put(name, StringUtils.parseHostPort((String)s));
            }
            s = props.getString("bound.ports");
            if (s == null) {
                return;
            }
            for (int port : this.ports = StringUtils.parseIntValues((String)s)) {
                this.boundPorts.add(port);
                String name = props.getString("mapping." + port, null);
                if (name == null) continue;
                this.boundToMultiplexerMap.put(port, name);
            }
        }
        int n = this.multiplexerPorts.size() + this.boundPorts.size();
        this.ports = new int[n];
        boolean bl = false;
        for (Integer port : this.multiplexerPorts) {
            this.ports[++var4_10] = port;
        }
        for (Integer port : this.boundPorts) {
            this.ports[++var4_11] = port;
        }
        if (debugEnabled) {
            log.debug("multiplexerPorts: " + this.multiplexerPorts);
            log.debug("boundPorts: " + this.boundPorts);
            log.debug("remoteMultiplexers: " + this.remoteMultiplexers);
            log.debug("remoteMultiplexerMap: " + this.remoteMultiplexerMap);
            log.debug("boundToMultiplexerMap: " + this.boundToMultiplexerMap);
        }
        this.init(this.ports);
    }

    @Override
    public NioContext createNioContext() {
        return new MultiplexerContext();
    }

    @Override
    public int getInitialInterest() {
        return 5;
    }

    @Override
    public void postAccept(ChannelWrapper key, ServerSocketChannel serverChannel) {
        int port = serverChannel.socket().getLocalPort();
        if (debugEnabled) {
            log.debug("accepting on port " + port);
        }
        MultiplexerContext context = (MultiplexerContext)key.getContext();
        if (this.multiplexerPorts.contains(port)) {
            context.setMultiplexerPort(port);
        } else if (this.boundPorts.contains(port)) {
            context.setBoundPort(port);
        }
        this.postAccept(key);
    }

    @Override
    public void postAccept(ChannelWrapper key) {
        MultiplexerContext context = (MultiplexerContext)key.getContext();
        if (context.isApplicationPort()) {
            if (debugEnabled) {
                log.debug("initializing outbound port " + context.getBoundPort());
            }
            this.transitionManager.transitionChannel(key, MultiplexerTransition.TO_IDLE);
            HostPort mult = this.getHostPortForBoundPort(context.getBoundPort());
            MultiplexerChannelHandler handler = new MultiplexerChannelHandler(this, mult.host(), mult.port(), key);
            MultiplexerChannelInitializer init = new MultiplexerChannelInitializer(handler);
            new Thread(init).start();
        } else if (context.isMultiplexerPort()) {
            if (debugEnabled) {
                log.debug("initializing multiplexing port " + context.getMultiplexerPort());
            }
            this.transitionManager.transitionChannel(key, MultiplexerTransition.TO_IDENTIFYING_INBOUND_CHANNEL);
        }
    }

    public HostPort getHostPortForBoundPort(int port) {
        String name = this.boundToMultiplexerMap.get(port);
        if (name == null) {
            return null;
        }
        return this.remoteMultiplexerMap.get(name);
    }

    public static void main(String ... args) {
        try {
            MultiplexerNioServer svr = new MultiplexerNioServer();
            svr.start();
            svr.join();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
    }
}

