/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer.generic;

import java.util.EnumMap;
import java.util.Map;
import org.jppf.server.nio.NioServerFactory;
import org.jppf.server.nio.NioState;
import org.jppf.server.nio.NioTransition;
import org.jppf.server.nio.multiplexer.generic.IdentifyingInboundChannelState;
import org.jppf.server.nio.multiplexer.generic.IdleState;
import org.jppf.server.nio.multiplexer.generic.MultiplexerNioServer;
import org.jppf.server.nio.multiplexer.generic.MultiplexerState;
import org.jppf.server.nio.multiplexer.generic.MultiplexerTransition;
import org.jppf.server.nio.multiplexer.generic.ReceivingState;
import org.jppf.server.nio.multiplexer.generic.SendingMultiplexingInfoState;
import org.jppf.server.nio.multiplexer.generic.SendingOrReceivingState;
import org.jppf.server.nio.multiplexer.generic.SendingState;

public final class MultiplexerServerFactory
extends NioServerFactory<MultiplexerState, MultiplexerTransition> {
    public MultiplexerServerFactory(MultiplexerNioServer server) {
        super(server);
    }

    @Override
    public Map<MultiplexerState, NioState<MultiplexerTransition>> createStateMap() {
        MultiplexerNioServer server = (MultiplexerNioServer)this.server;
        EnumMap<MultiplexerState, NioState<MultiplexerTransition>> map = new EnumMap<MultiplexerState, NioState<MultiplexerTransition>>(MultiplexerState.class);
        map.put(MultiplexerState.SENDING_OR_RECEIVING, new SendingOrReceivingState(server));
        map.put(MultiplexerState.SENDING, new SendingState(server));
        map.put(MultiplexerState.IDLE, new IdleState(server));
        map.put(MultiplexerState.RECEIVING, new ReceivingState(server));
        map.put(MultiplexerState.IDENTIFYING_INBOUND_CHANNEL, new IdentifyingInboundChannelState(server));
        map.put(MultiplexerState.SENDING_MULTIPLEXING_INFO, new SendingMultiplexingInfoState(server));
        return map;
    }

    @Override
    public Map<MultiplexerTransition, NioTransition<MultiplexerState>> createTransitionMap() {
        EnumMap<MultiplexerTransition, NioTransition<MultiplexerState>> map = new EnumMap<MultiplexerTransition, NioTransition<MultiplexerState>>(MultiplexerTransition.class);
        map.put(MultiplexerTransition.TO_SENDING_OR_RECEIVING, this.transition(MultiplexerState.SENDING_OR_RECEIVING, 1));
        map.put(MultiplexerTransition.TO_SENDING, this.transition(MultiplexerState.SENDING, 5));
        map.put(MultiplexerTransition.TO_RECEIVING, this.transition(MultiplexerState.RECEIVING, 1));
        map.put(MultiplexerTransition.TO_IDENTIFYING_INBOUND_CHANNEL, this.transition(MultiplexerState.IDENTIFYING_INBOUND_CHANNEL, 1));
        map.put(MultiplexerTransition.TO_SENDING_MULTIPLEXING_INFO, this.transition(MultiplexerState.SENDING_MULTIPLEXING_INFO, 5));
        map.put(MultiplexerTransition.TO_IDLE, this.transition(MultiplexerState.IDLE, 0));
        return map;
    }

    private NioTransition<MultiplexerState> transition(MultiplexerState state, int ops) {
        return new NioTransition<MultiplexerState>(state, ops);
    }
}

