/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer.generic;

import java.nio.ByteBuffer;
import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.multiplexer.generic.ByteBufferWrapper;
import org.jppf.server.nio.multiplexer.generic.MultiplexerContext;
import org.jppf.server.nio.multiplexer.generic.MultiplexerNioServer;
import org.jppf.server.nio.multiplexer.generic.MultiplexerServerState;
import org.jppf.server.nio.multiplexer.generic.MultiplexerState;
import org.jppf.server.nio.multiplexer.generic.MultiplexerTransition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingState
extends MultiplexerServerState {
    private static Logger log = LoggerFactory.getLogger(ReceivingState.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public ReceivingState(MultiplexerNioServer server) {
        super(server);
    }

    @Override
    public MultiplexerTransition performTransition(ChannelWrapper<?> wrapper) throws Exception {
        ByteBuffer message;
        MultiplexerContext context = (MultiplexerContext)wrapper.getContext();
        if (debugEnabled) {
            log.debug("exec() for " + wrapper);
        }
        if ((message = context.readMultiplexerMessage(wrapper)) != null) {
            if (debugEnabled) {
                log.debug("read message for " + wrapper + " done");
            }
            ChannelWrapper linkedKey = context.getLinkedKey();
            MultiplexerContext linkedContext = (MultiplexerContext)linkedKey.getContext();
            linkedContext.addPendingMessage(new ByteBufferWrapper(message, context.newReadMessageCount()));
            if (!MultiplexerState.SENDING.equals(linkedContext.getState())) {
                this.server.getTransitionManager().transitionChannel(linkedKey, MultiplexerTransition.TO_SENDING);
            }
            if (!context.isEof()) {
                return MultiplexerTransition.TO_SENDING_OR_RECEIVING;
            }
        }
        if (context.isEof()) {
            context.setEof(false);
            return MultiplexerTransition.TO_IDLE;
        }
        return MultiplexerTransition.TO_RECEIVING;
    }
}

