/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer.generic;

import java.net.ConnectException;
import java.nio.ByteBuffer;
import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.NioMessage;
import org.jppf.server.nio.multiplexer.generic.MultiplexerContext;
import org.jppf.server.nio.multiplexer.generic.MultiplexerNioServer;
import org.jppf.server.nio.multiplexer.generic.MultiplexerServerState;
import org.jppf.server.nio.multiplexer.generic.MultiplexerTransition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingMultiplexingInfoState
extends MultiplexerServerState {
    private static Logger log = LoggerFactory.getLogger(SendingMultiplexingInfoState.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public SendingMultiplexingInfoState(MultiplexerNioServer server) {
        super(server);
    }

    @Override
    public MultiplexerTransition performTransition(ChannelWrapper<?> wrapper) throws Exception {
        MultiplexerContext context;
        if (wrapper.isReadable()) {
            throw new ConnectException("multiplexer channel " + wrapper + " has been disconnected");
        }
        if (debugEnabled) {
            log.debug("exec() for " + wrapper);
        }
        if ((context = (MultiplexerContext)wrapper.getContext()).getMessage() == null) {
            MultiplexerContext linkedContext = (MultiplexerContext)context.getLinkedKey().getContext();
            NioMessage msg = new NioMessage();
            msg.length = 4;
            msg.buffer = ByteBuffer.wrap(new byte[4]);
            msg.buffer.putInt(linkedContext.getBoundPort());
            msg.buffer.flip();
            context.setMessage(msg);
        }
        if (context.writeMessage(wrapper)) {
            if (debugEnabled) {
                log.debug("message sent to remote multiplexer " + wrapper);
            }
            context.setMessage(null);
            return MultiplexerTransition.TO_SENDING_OR_RECEIVING;
        }
        return MultiplexerTransition.TO_SENDING_MULTIPLEXING_INFO;
    }
}

