/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer.generic;

import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.multiplexer.generic.MultiplexerContext;
import org.jppf.server.nio.multiplexer.generic.MultiplexerNioServer;
import org.jppf.server.nio.multiplexer.generic.MultiplexerServerState;
import org.jppf.server.nio.multiplexer.generic.MultiplexerTransition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingOrReceivingState
extends MultiplexerServerState {
    private static Logger log = LoggerFactory.getLogger(SendingOrReceivingState.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public SendingOrReceivingState(MultiplexerNioServer server) {
        super(server);
    }

    @Override
    public MultiplexerTransition performTransition(ChannelWrapper<?> wrapper) throws Exception {
        MultiplexerContext context = (MultiplexerContext)wrapper.getContext();
        MultiplexerTransition trans = MultiplexerTransition.TO_SENDING_OR_RECEIVING;
        if (context.hasPendingMessage() || context.getCurrentMessage() != null) {
            trans = MultiplexerTransition.TO_SENDING;
        } else if (wrapper.isReadable()) {
            trans = MultiplexerTransition.TO_RECEIVING;
        }
        if (debugEnabled) {
            log.debug("returning " + (Object)((Object)trans) + " for " + wrapper);
        }
        return trans;
    }
}

