/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.nio.multiplexer.generic;

import org.jppf.server.nio.ChannelWrapper;
import org.jppf.server.nio.multiplexer.generic.ByteBufferWrapper;
import org.jppf.server.nio.multiplexer.generic.MultiplexerContext;
import org.jppf.server.nio.multiplexer.generic.MultiplexerNioServer;
import org.jppf.server.nio.multiplexer.generic.MultiplexerServerState;
import org.jppf.server.nio.multiplexer.generic.MultiplexerTransition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingState
extends MultiplexerServerState {
    private static Logger log = LoggerFactory.getLogger(SendingState.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public SendingState(MultiplexerNioServer server) {
        super(server);
    }

    @Override
    public MultiplexerTransition performTransition(ChannelWrapper<?> wrapper) throws Exception {
        MultiplexerContext context = (MultiplexerContext)wrapper.getContext();
        if (context.hasPendingMessage() && context.getCurrentMessage() == null) {
            ByteBufferWrapper message = context.nextPendingMessage();
            context.setCurrentMessage(message.buffer);
            if (debugEnabled) {
                log.debug(wrapper.toString() + " about to send message #" + message.order + ": " + (message.buffer.limit() + 1) + " bytes");
            }
        }
        if (context.getCurrentMessage() == null) {
            return MultiplexerTransition.TO_SENDING_OR_RECEIVING;
        }
        if (context.writeMultiplexerMessage(wrapper)) {
            if (debugEnabled) {
                log.debug(wrapper.toString() + " message sent");
            }
            context.setCurrentMessage(null);
            return context.hasPendingMessage() ? MultiplexerTransition.TO_SENDING : MultiplexerTransition.TO_SENDING_OR_RECEIVING;
        }
        return MultiplexerTransition.TO_SENDING;
    }
}

