/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.util.ArrayList;
import java.util.List;
import org.jppf.io.DataLocation;
import org.jppf.server.protocol.JPPFTaskBundle;

public class BundleWrapper {
    private JPPFTaskBundle bundle = null;
    private DataLocation dataProvider = null;
    private List<DataLocation> tasks = new ArrayList<DataLocation>();

    public BundleWrapper() {
    }

    public BundleWrapper(JPPFTaskBundle bundle) {
        this.bundle = bundle;
    }

    public JPPFTaskBundle getBundle() {
        return this.bundle;
    }

    public void setBundle(JPPFTaskBundle bundle) {
        this.bundle = bundle;
    }

    public DataLocation getDataProvider() {
        return this.dataProvider;
    }

    public void setDataProvider(DataLocation dataProvider) {
        this.dataProvider = dataProvider;
    }

    public void addTask(DataLocation task) {
        this.tasks.add(task);
    }

    public List<DataLocation> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<DataLocation> tasks) {
        this.tasks = tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleWrapper copy(int nbTasks) {
        BundleWrapper wrapper = null;
        BundleWrapper bundleWrapper = this;
        synchronized (bundleWrapper) {
            wrapper = new BundleWrapper(this.bundle.copy(nbTasks));
            for (int i = 0; i < nbTasks; ++i) {
                wrapper.addTask(this.tasks.remove(0));
            }
        }
        wrapper.setDataProvider(this.dataProvider.copy());
        return wrapper;
    }

    public void merge(BundleWrapper other, boolean after) {
        int n = other.getBundle().getTaskCount();
        this.bundle.setTaskCount(this.bundle.getTaskCount() + n);
        this.bundle.getJobSLA().setSuspended(other.getBundle().getJobSLA().isSuspended());
        if (after) {
            for (DataLocation task : other.getTasks()) {
                this.tasks.add(task);
            }
        } else {
            for (int i = n - 1; i >= 0; --i) {
                this.tasks.add(0, other.getTasks().get(i));
            }
        }
    }
}

