/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.protocol;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.jppf.io.ByteBufferOutputStream;
import org.jppf.server.protocol.AbstractLocation;

public class MemoryLocation
extends AbstractLocation<byte[]> {
    private int offset = 0;
    private int len = -1;

    public MemoryLocation(int size) {
        this(new byte[size], 0, size);
    }

    public MemoryLocation(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public MemoryLocation(byte[] buffer, int offset, int len) {
        super(buffer);
        this.offset = offset;
        this.len = len;
    }

    @Override
    public InputStream getInputStream() throws Exception {
        return new ByteArrayInputStream((byte[])this.path, this.offset, this.len);
    }

    @Override
    public OutputStream getOutputStream() throws Exception {
        return new ByteBufferOutputStream(ByteBuffer.wrap((byte[])this.path, this.offset, this.len));
    }

    @Override
    public long size() {
        return this.len;
    }

    @Override
    public byte[] toByteArray() throws Exception {
        return (byte[])this.path;
    }
}

