/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.scheduler.bundle.proportional;

import java.util.HashSet;
import java.util.Set;
import org.jppf.server.scheduler.bundle.AbstractBundler;
import org.jppf.server.scheduler.bundle.BundleDataHolder;
import org.jppf.server.scheduler.bundle.BundlePerformanceSample;
import org.jppf.server.scheduler.bundle.LoadBalancingProfile;
import org.jppf.server.scheduler.bundle.proportional.ProportionalTuneProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProportionalBundler
extends AbstractBundler {
    private static Logger log = LoggerFactory.getLogger(AbstractProportionalBundler.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static Set<AbstractProportionalBundler> bundlers = new HashSet<AbstractProportionalBundler>();
    protected BundleDataHolder dataHolder = null;
    protected int bundleSize = 1;

    public AbstractProportionalBundler(LoadBalancingProfile profile) {
        super(profile);
        if (debugEnabled) {
            log.debug("Bundler#" + this.bundlerNumber + ": Using Auto-Tuned bundle size - the initial size is " + this.bundleSize + ", profile: " + profile);
        }
        this.dataHolder = new BundleDataHolder(((ProportionalTuneProfile)profile).getPerformanceCacheSize());
    }

    @Override
    public int getBundleSize() {
        return this.bundleSize;
    }

    public void setBundleSize(int size) {
        this.bundleSize = size <= 0 ? 1 : size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void feedback(int size, double time) {
        if (size <= 0) {
            return;
        }
        BundlePerformanceSample sample = new BundlePerformanceSample(time / (double)size, size);
        Set<AbstractProportionalBundler> set = bundlers;
        synchronized (set) {
            this.dataHolder.addSample(sample);
            this.computeBundleSizes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setup() {
        Set<AbstractProportionalBundler> set = bundlers;
        synchronized (set) {
            bundlers.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Set<AbstractProportionalBundler> set = bundlers;
        synchronized (set) {
            bundlers.remove(this);
        }
    }

    public BundleDataHolder getDataHolder() {
        return this.dataHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeBundleSizes() {
        Set<AbstractProportionalBundler> set = bundlers;
        synchronized (set) {
            BundleDataHolder h;
            double maxMean = Double.NEGATIVE_INFINITY;
            double minMean = Double.POSITIVE_INFINITY;
            AbstractProportionalBundler minBundler = null;
            double meanSum = 0.0;
            for (AbstractProportionalBundler b : bundlers) {
                h = b.getDataHolder();
                double m = h.getMean();
                if (m > maxMean) {
                    maxMean = m;
                }
                if (!(m < minMean)) continue;
                minMean = m;
                minBundler = b;
            }
            for (AbstractProportionalBundler b : bundlers) {
                h = b.getDataHolder();
                meanSum += this.normalize(h.getMean());
            }
            int max = this.maxSize();
            int sum = 0;
            for (AbstractProportionalBundler b : bundlers) {
                BundleDataHolder h2 = b.getDataHolder();
                double p = this.normalize(h2.getMean()) / meanSum;
                int size = Math.max(1, (int)(p * (double)max));
                if (size >= max) {
                    size = max - 1;
                }
                b.setBundleSize(size);
                sum += size;
            }
            if (sum < max && minBundler != null) {
                int size = minBundler.getBundleSize();
                minBundler.setBundleSize(size + (max - sum));
            }
            if (debugEnabled) {
                StringBuilder sb = new StringBuilder();
                sb.append("bundler info:\n");
                sb.append("minMean = ").append(minMean).append(", maxMean = ").append(maxMean).append(", maxSize = ").append(max).append("\n");
                for (AbstractProportionalBundler b : bundlers) {
                    sb.append("bundler #").append(b.getBundlerNumber()).append(" : ").append(b.getBundleSize()).append(":\n");
                    sb.append("  ").append(b.getDataHolder()).append("\n");
                }
                log.debug(sb.toString());
            }
        }
    }

    public double normalize(double x) {
        double r = 1.0;
        for (int i = 0; i < ((ProportionalTuneProfile)this.profile).getProportionalityFactor(); ++i) {
            r *= x;
        }
        return 1.0 / r;
    }
}

