/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.server.scheduler.bundle.rl;

import org.jppf.server.scheduler.bundle.AbstractBundler;
import org.jppf.server.scheduler.bundle.BundleDataHolder;
import org.jppf.server.scheduler.bundle.BundlePerformanceSample;
import org.jppf.server.scheduler.bundle.LoadBalancingProfile;
import org.jppf.server.scheduler.bundle.rl.RLProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRLBundler
extends AbstractBundler {
    private static Logger log = LoggerFactory.getLogger(AbstractRLBundler.class);
    private static boolean debugEnabled = log.isDebugEnabled();
    private static final int STEP = 1;
    protected int action = 1;
    protected BundleDataHolder dataHolder = null;
    protected int bundleSize = 1;
    protected int prevBundleSize = 1;

    public AbstractRLBundler(LoadBalancingProfile profile) {
        super(profile);
        log.info("Bundler#" + this.bundlerNumber + ": Using Reinforcement Learning bundle size");
        log.info("Bundler#" + this.bundlerNumber + ": The initial size is " + this.bundleSize + ", performanceVariationThreshold = " + ((RLProfile)profile).getPerformanceVariationThreshold());
        this.dataHolder = new BundleDataHolder(((RLProfile)profile).getPerformanceCacheSize());
        this.action = ((RLProfile)profile).getMaxActionRange();
    }

    @Override
    public int getBundleSize() {
        return this.bundleSize;
    }

    public void setBundleSize(int bundleSize) {
        this.bundleSize = bundleSize;
    }

    @Override
    public void feedback(int size, double totalTime) {
        if (size <= 0) {
            return;
        }
        BundlePerformanceSample sample = new BundlePerformanceSample(totalTime / (double)size, size);
        this.dataHolder.addSample(sample);
        double d = this.dataHolder.getPreviousMean() - this.dataHolder.getMean();
        double threshold = ((RLProfile)this.profile).getPerformanceVariationThreshold() * this.dataHolder.getPreviousMean();
        this.prevBundleSize = this.bundleSize;
        this.action = d < -threshold ? (this.action += (int)Math.signum(this.action) * 1) : (d > threshold ? (int)(-Math.signum(this.action)) * 1 : 1);
        int maxActionRange = ((RLProfile)this.profile).getMaxActionRange();
        if (this.action > maxActionRange) {
            this.action = maxActionRange;
        } else if (this.action < -maxActionRange) {
            this.action = -maxActionRange;
        }
        this.bundleSize += this.action;
        int max = this.maxSize();
        if (this.bundleSize > max) {
            this.bundleSize = max;
        }
        if (this.bundleSize <= 0) {
            this.bundleSize = 1;
        }
        if (debugEnabled) {
            StringBuilder sb = new StringBuilder();
            sb.append("bundler #").append(this.getBundlerNumber()).append(" : size=").append(this.getBundleSize());
            sb.append(", ").append(this.getDataHolder());
            log.debug(sb.toString());
        }
    }

    public void feedback2(int size, double totalTime) {
        if (size <= 0) {
            return;
        }
        BundlePerformanceSample sample = new BundlePerformanceSample(totalTime / (double)size, size);
        this.dataHolder.addSample(sample);
        double d = this.dataHolder.getPreviousMean() - this.dataHolder.getMean();
        double threshold = ((RLProfile)this.profile).getPerformanceVariationThreshold() * this.dataHolder.getPreviousMean();
        this.prevBundleSize = this.bundleSize;
        this.action = d < -threshold ? (this.action += (int)Math.signum(this.action) * 1) : (d > threshold ? (int)(-Math.signum(this.action)) * Math.max(1, Math.abs(this.action / 2)) : 0);
        int maxActionRange = ((RLProfile)this.profile).getMaxActionRange();
        if (this.action > maxActionRange) {
            this.action = maxActionRange;
        } else if (this.action < -maxActionRange) {
            this.action = -maxActionRange;
        }
        this.bundleSize += this.action;
        int max = this.maxSize();
        if (this.bundleSize > max) {
            this.bundleSize = max;
        }
        if (this.bundleSize <= 0) {
            this.bundleSize = 1;
        }
        if (debugEnabled) {
            StringBuilder sb = new StringBuilder();
            sb.append("bundler #").append(this.getBundlerNumber()).append(" : size=").append(this.getBundleSize());
            sb.append(", ").append(this.getDataHolder());
            log.debug(sb.toString());
        }
    }

    @Override
    public void setup() {
    }

    @Override
    public void dispose() {
        this.dataHolder = null;
    }

    public BundleDataHolder getDataHolder() {
        return this.dataHolder;
    }
}

