/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.task.storage;

import org.jppf.classloader.JPPFClassLoader;
import org.jppf.task.storage.MemoryMapDataProvider;
import org.jppf.utils.JPPFCallable;
import org.jppf.utils.ObjectSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientDataProvider
extends MemoryMapDataProvider {
    private static Logger log = LoggerFactory.getLogger(ClientDataProvider.class);
    private static boolean debugEnabled = log.isDebugEnabled();

    public <V> Object computeValue(Object key, JPPFCallable<V> callable) {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        Object result = null;
        if (callable != null) {
            result = this.getValueFromClient(callable);
        }
        this.setValue(key, result == null ? SpecialValue.NULL_VALUE : result);
        return SpecialValue.NULL_VALUE.equals(result) ? null : result;
    }

    private <V> Object getValueFromClient(JPPFCallable<V> callable) {
        ClassLoader cl = callable.getClass().getClassLoader();
        if (!(cl instanceof JPPFClassLoader)) {
            return null;
        }
        try {
            JPPFClassLoader loader = (JPPFClassLoader)cl;
            Class clazz = loader.loadClass("org.jppf.utils.ObjectSerializerImpl");
            ObjectSerializer ser = (ObjectSerializer)clazz.newInstance();
            byte[] bytes = ser.serialize(callable).getBuffer();
            bytes = loader.computeRemoteData(bytes);
            if (bytes == null) {
                return null;
            }
            return ser.deserialize(bytes);
        }
        catch (Exception ignored) {
            ignored.printStackTrace();
            return null;
        }
    }

    private static enum SpecialValue {
        NULL_VALUE;

    }
}

