/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.File;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalizationUtils {
    private static Logger log = LoggerFactory.getLogger(LocalizationUtils.class);

    public static String getLocalized(String baseName, String key) {
        return LocalizationUtils.getLocalized(baseName, key, key);
    }

    public static String getLocalized(String baseName, String key, String def) {
        String result;
        block6: {
            if (baseName == null) {
                return def;
            }
            ResourceBundle bundle = null;
            try {
                bundle = ResourceBundle.getBundle(baseName);
            }
            catch (Exception e) {
                log.debug("Could not find resource bundle \"" + baseName + "\"");
                if (log.isDebugEnabled()) {
                    log.debug(e.getMessage(), (Throwable)e);
                }
                return def;
            }
            result = null;
            try {
                result = bundle.getString(key);
            }
            catch (Exception e) {
                log.debug("Could not find key \"" + key + "\" in resource bundle \"" + baseName + "\"");
                if (!log.isDebugEnabled()) break block6;
                log.debug(e.getMessage(), (Throwable)e);
            }
        }
        return result == null ? def : result;
    }

    public static String getLocalisationBase(String base, String filename) {
        String result = null;
        try {
            File file = new File(filename);
            result = file.getName();
            int idx = result.lastIndexOf(".");
            if (idx >= 0) {
                result = result.substring(0, idx);
            }
            result = base + "/" + result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

