/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.jppf.io.DataLocation;
import org.jppf.serialization.JPPFObjectStreamFactory;
import org.jppf.utils.JPPFBuffer;
import org.jppf.utils.JPPFByteArrayOutputStream;
import org.jppf.utils.ObjectSerializer;

public class ObjectSerializerImpl
implements ObjectSerializer {
    public JPPFBuffer serialize(Object o) throws Exception {
        return this.serialize(o, false);
    }

    public JPPFBuffer serialize(Object o, boolean noCopy) throws Exception {
        JPPFByteArrayOutputStream baos = new JPPFByteArrayOutputStream();
        this.serialize(o, (OutputStream)baos);
        byte[] data = noCopy ? baos.getBuf() : baos.toByteArray();
        JPPFBuffer buf = new JPPFBuffer(data, baos.size());
        return buf;
    }

    public void serialize(Object o, OutputStream os) throws Exception {
        ObjectOutputStream oos = JPPFObjectStreamFactory.newObjectOutputStream((OutputStream)os);
        oos.writeObject(o);
        oos.flush();
        oos.close();
    }

    public void serialize(Object o, DataLocation location) throws Exception {
        ObjectOutputStream oos = JPPFObjectStreamFactory.newObjectOutputStream((OutputStream)location.getOutputStream());
        oos.writeObject(o);
        oos.flush();
        oos.close();
    }

    public Object deserialize(JPPFBuffer buf) throws Exception {
        return this.deserialize(new ByteArrayInputStream(buf.getBuffer(), 0, buf.getLength()));
    }

    public Object deserialize(byte[] bytes) throws Exception {
        return this.deserialize(new ByteArrayInputStream(bytes));
    }

    public Object deserialize(byte[] bytes, int offset, int length) throws Exception {
        return this.deserialize(new ByteArrayInputStream(bytes, offset, length));
    }

    public Object deserialize(InputStream is) throws Exception {
        Object o = null;
        ObjectInputStream ois = JPPFObjectStreamFactory.newObjectInputStream((InputStream)is);
        o = ois.readObject();
        ois.close();
        return o;
    }
}

