/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.jppf.server.protocol.JPPFRunnable;
import org.jppf.utils.StringUtils;

public class ReflectionUtils {
    public static String dumpObject(Object o) {
        return ReflectionUtils.dumpObject(o, "\n");
    }

    public static String dumpObject(Object o, String separator) {
        if (o == null) {
            return "null";
        }
        Class<?> clazz = o.getClass();
        StringBuilder sb = new StringBuilder();
        sb.append(clazz.getName()).append("@").append(Integer.toHexString(o.hashCode())).append(separator);
        Method[] methods = clazz.getMethods();
        Method getter = null;
        TreeMap<String, Object> attrMap = new TreeMap<String, Object>();
        for (int i = 0; i < methods.length; ++i) {
            if (!ReflectionUtils.isGetter(methods[i])) continue;
            getter = methods[i];
            String attrName = null;
            attrName = getter.getName().substring(getter.getName().startsWith("get") ? 3 : 2);
            attrName = attrName.substring(0, 1).toLowerCase() + attrName.substring(1);
            Object value = null;
            try {
                value = getter.invoke(o, (Object[])null);
                if (value == null) {
                    value = "null";
                }
            }
            catch (Exception e) {
                value = "*Error: " + e.getMessage() + "*";
            }
            attrMap.put(attrName, value);
        }
        Iterator it = attrMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            sb.append((String)entry.getKey()).append("=").append(entry.getValue());
            if (!it.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    public static boolean isGetter(Method meth) {
        Class<?> type = meth.getReturnType();
        if (Void.TYPE.equals(type)) {
            return false;
        }
        if (!StringUtils.startsWithOneOf((String)meth.getName(), (boolean)false, (String[])new String[]{"get", "is"})) {
            return false;
        }
        if (meth.getName().startsWith("is") && !Boolean.class.equals(type) && !Boolean.TYPE.equals(type)) {
            return false;
        }
        Class<?>[] paramTypes = meth.getParameterTypes();
        return paramTypes == null || paramTypes.length <= 0;
    }

    public static boolean isSetter(Method meth) {
        Class<?> type = meth.getReturnType();
        if (!Void.TYPE.equals(type)) {
            return false;
        }
        if (!meth.getName().startsWith("set")) {
            return false;
        }
        Class<?>[] paramTypes = meth.getParameterTypes();
        return paramTypes != null && paramTypes.length == 1;
    }

    public static Method getGetter(Class clazz, String name) {
        Method[] methods = clazz.getMethods();
        Method getter = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!ReflectionUtils.isGetter(methods[i]) || !name.equals(methods[i].getName())) continue;
            getter = methods[i];
            break;
        }
        return getter;
    }

    public static Method getSetter(Class clazz, String name) {
        Method[] methods = clazz.getMethods();
        Method setter = null;
        for (int i = 0; i < methods.length; ++i) {
            if (!ReflectionUtils.isSetter(methods[i]) || !name.equals(methods[i].getName())) continue;
            setter = methods[i];
            break;
        }
        return setter;
    }

    public static Method getGetterForAttribute(Class clazz, String attrName) {
        String basename = attrName.substring(0, 1).toUpperCase() + attrName.substring(1);
        Method method = ReflectionUtils.getGetter(clazz, "get" + basename);
        if (method == null) {
            method = ReflectionUtils.getGetter(clazz, "is" + basename);
        }
        return method;
    }

    public static Method getSetterForAttribute(Class clazz, String attrName) {
        String basename = attrName.substring(0, 1).toUpperCase() + attrName.substring(1);
        return ReflectionUtils.getSetter(clazz, "set" + basename);
    }

    public static Method[] getAllBeanMethods(Class clazz, boolean getters) {
        Method[] allMethods;
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Method meth : allMethods = clazz.getMethods()) {
            if ((!getters || !ReflectionUtils.isGetter(meth)) && (getters || !ReflectionUtils.isSetter(meth))) continue;
            methodList.add(meth);
        }
        return methodList.toArray(new Method[0]);
    }

    public static Object deepCopy(Object o) {
        return null;
    }

    public static boolean isJPPFAnnotated(Class<?> clazz) {
        return ReflectionUtils.getJPPFAnnotatedElement(clazz) != null;
    }

    public static AnnotatedElement getJPPFAnnotatedElement(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (!ReflectionUtils.isJPPFAnnotated(method)) continue;
            return method;
        }
        for (Executable executable : clazz.getDeclaredConstructors()) {
            if (!ReflectionUtils.isJPPFAnnotated(executable)) continue;
            return executable;
        }
        return null;
    }

    public static boolean isJPPFAnnotated(AnnotatedElement annotatedElement) {
        Annotation[] annotations;
        if (annotatedElement == null) {
            return false;
        }
        for (Annotation a : annotations = annotatedElement.getAnnotations()) {
            if (!JPPFRunnable.class.equals(a.annotationType())) continue;
            return true;
        }
        return false;
    }

    public static Method getMatchingMethod(Class clazz, String name, Object[] args) {
        Method[] methods;
        Class[] argTypes = ReflectionUtils.createTypeArray(args);
        for (Method m : methods = clazz.getDeclaredMethods()) {
            if (!m.getName().equals(name) || !ReflectionUtils.matchingTypes(argTypes, m.getParameterTypes())) continue;
            return m;
        }
        return null;
    }

    public static Constructor getMatchingConstructor(Class clazz, Object[] args) {
        Constructor<?>[] constructors;
        Class[] argTypes = ReflectionUtils.createTypeArray(args);
        for (Constructor<?> c : constructors = clazz.getDeclaredConstructors()) {
            if (!ReflectionUtils.matchingTypes(argTypes, c.getParameterTypes())) continue;
            return c;
        }
        return null;
    }

    public static boolean matchingTypes(Class<?>[] argTypes, Class<?>[] types) {
        if (argTypes.length != types.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            Class c;
            if (argTypes[i] == null) continue;
            Class clazz = c = types[i].isPrimitive() ? ReflectionUtils.mapPrimitveType(types[i]) : types[i];
            if (c.isAssignableFrom(argTypes[i])) continue;
            return false;
        }
        return true;
    }

    public static Class mapPrimitveType(Class type) {
        if (Boolean.TYPE.equals(type)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(type)) {
            return Character.class;
        }
        if (Byte.TYPE.equals(type)) {
            return Byte.class;
        }
        if (Short.TYPE.equals(type)) {
            return Short.class;
        }
        if (Integer.TYPE.equals(type)) {
            return Integer.class;
        }
        if (Long.TYPE.equals(type)) {
            return Long.class;
        }
        if (Float.TYPE.equals(type)) {
            return Float.class;
        }
        if (Double.TYPE.equals(type)) {
            return Double.class;
        }
        return type;
    }

    public static Class[] createTypeArray(Object[] args) {
        if (args == null || args.length == 0) {
            return new Class[0];
        }
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i] != null ? args[i].getClass() : null;
        }
        return argTypes;
    }
}

