/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import org.jppf.utils.FileUtils;

public class ThumbnailGenerator {
    private static final String TH_PREFIX = "_th_";
    private static final String DEFAULT_INCLUDE_PATH = "C:/Workspaces/SourceForge/JPPF/docs/home/templates";
    private static final int DEFAULT_ROW_LENGTH = 10;
    private int rowLength = 10;
    private String path = null;
    private int width = 0;
    private int height = 0;
    private String includePath = null;
    private Map<File, File> fileMap = new TreeMap<File, File>();

    public ThumbnailGenerator(String path, int width, int height) {
        this(path, width, height, DEFAULT_INCLUDE_PATH, 10);
    }

    public ThumbnailGenerator(String path, int width, int height, int rowLength) {
        this(path, width, height, DEFAULT_INCLUDE_PATH, rowLength);
    }

    public ThumbnailGenerator(String path, int width, int height, String includePath, int rowLength) {
        this.path = path;
        this.width = width;
        this.height = height;
        this.includePath = includePath;
        this.rowLength = rowLength;
    }

    public void generate() throws Exception {
        this.generateFileMap();
        this.generateThumbnails();
        this.generateIncludeFile();
    }

    private void generateThumbnails() throws Exception {
        for (Map.Entry<File, File> entry : this.fileMap.entrySet()) {
            BufferedImage img = ImageIO.read(entry.getKey());
            BufferedImage thumbnail = this.scale(img);
            ImageIO.write((RenderedImage)thumbnail, "jpeg", entry.getValue());
        }
    }

    private void generateIncludeFile() throws Exception {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        String indent = "\t\t\t\t\t";
        sb.append(indent).append("<table align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"5\">\n");
        for (Map.Entry<File, File> entry : this.fileMap.entrySet()) {
            if (count % this.rowLength == 0) {
                if (count > 0) {
                    sb.append(indent).append("\t</tr>\n");
                }
                sb.append(indent).append("\t<tr>\n");
            }
            String name1 = entry.getKey().getName();
            String name2 = entry.getValue().getName();
            sb.append(indent).append("\t\t$template{name=\"shots_cell\" image=\"");
            sb.append(name1);
            sb.append("\" thumbnail=\"");
            sb.append(name2);
            sb.append("\"}$\n");
            ++count;
        }
        sb.append(indent).append("\t</tr>\n");
        sb.append(indent).append("</table>\n");
        FileUtils.writeTextFile((String)(this.includePath + "/shots.html"), (String)sb.toString());
        File file = this.fileMap.keySet().iterator().next();
        FileUtils.writeTextFile((String)(this.includePath + "/first-shot.html"), (String)file.getName());
    }

    private void generateFileMap() throws Exception {
        File[] list;
        File dir = new File(this.path);
        if (!dir.isDirectory()) {
            throw new IOException("The specified path is not a directory");
        }
        for (File file : list = dir.listFiles(new ImageFileFilter("gif", "jpg", "png"))) {
            String s = this.path;
            if (s.endsWith("/") || s.endsWith("\\")) {
                s = s.substring(0, s.length() - 1);
            }
            s = s + "/_th_" + file.getName();
            int idx = s.lastIndexOf(".");
            s = s.substring(0, idx + 1) + "jpg";
            this.fileMap.put(file, new File(s));
        }
    }

    private BufferedImage scale(BufferedImage img) {
        int w = img.getWidth();
        int h = img.getHeight();
        double r = Math.max((double)w / (double)this.width, (double)h / (double)this.height);
        BufferedImage thumbnail = new BufferedImage((int)((double)w / r), (int)((double)h / r), 1);
        Graphics2D g = thumbnail.createGraphics();
        g.drawImage(img.getScaledInstance((int)((double)w / r), (int)((double)h / r), 16), 0, 0, null);
        return thumbnail;
    }

    public static void main(String ... args) {
        try {
            String path = args[0];
            int width = Integer.valueOf(args[1]);
            int height = Integer.valueOf(args[2]);
            String includePath = args[3];
            int rowLength = Integer.valueOf(args[4]);
            System.out.println("Using folder = " + path + ", max width = " + width + ", max height = " + height + ", include file path = " + includePath + ", thumbnails per row = " + rowLength);
            ThumbnailGenerator tg = new ThumbnailGenerator(path, width, height, includePath, rowLength);
            tg.generate();
            System.out.println("finished");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class ImageFileFilter
    implements FileFilter {
        private String[] extensions = null;

        public ImageFileFilter(String ... extensions) {
            this.extensions = extensions;
        }

        @Override
        public boolean accept(File file) {
            String ext = FileUtils.getFileExtension((File)file);
            if (file.getName().startsWith(ThumbnailGenerator.TH_PREFIX)) {
                return false;
            }
            for (String s : this.extensions) {
                if (!s.equalsIgnoreCase(ext)) continue;
                return true;
            }
            return false;
        }
    }
}

