/*
 * Decompiled with CFR 0.152.
 */
package org.jppf.utils;

import java.io.Serializable;

public class TimeSnapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String title = "";
    private long totalTime = 0L;
    private long latestTime = 0L;
    private long minTime = Long.MAX_VALUE;
    private long maxTime = 0L;
    private double avgTime = 0.0;

    public TimeSnapshot(String title) {
        this.title = title;
    }

    public void newTime(long time, int count, int totalCount) {
        this.totalTime += time;
        if (count > 0) {
            this.latestTime = time / (long)count;
            if (this.latestTime > this.maxTime) {
                this.maxTime = this.latestTime;
            }
            if (this.latestTime < this.minTime) {
                this.minTime = this.latestTime;
            }
            if (totalCount > 0) {
                this.avgTime = (double)this.totalTime / (double)totalCount;
            }
        }
    }

    public TimeSnapshot makeCopy() {
        TimeSnapshot ts = new TimeSnapshot(this.title);
        ts.totalTime = this.totalTime;
        ts.latestTime = this.latestTime;
        ts.minTime = this.minTime;
        ts.maxTime = this.maxTime;
        ts.avgTime = this.avgTime;
        return ts;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.title).append(" total time : ").append(this.totalTime).append("\n");
        sb.append(this.title).append(" latest time : ").append(this.latestTime).append("\n");
        sb.append(this.title).append(" min time : ").append(this.minTime).append("\n");
        sb.append(this.title).append(" max time : ").append(this.maxTime).append("\n");
        sb.append(this.title).append(" avg time : ").append(this.avgTime).append("\n");
        return sb.toString();
    }

    public void setTotalTime(long totalTime) {
        this.totalTime = totalTime;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public void setLatestTime(long latestTime) {
        this.latestTime = latestTime;
    }

    public long getLatestTime() {
        return this.latestTime;
    }

    public void setMinTime(long minTime) {
        this.minTime = minTime;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public void setMaxTime(long maxTime) {
        this.maxTime = maxTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public void setAvgTime(double avgTime) {
        this.avgTime = avgTime;
    }

    public double getAvgTime() {
        return this.avgTime;
    }
}

