/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.AsyncCompareResultListener;
import com.unboundid.ldap.sdk.AsyncRequestID;
import com.unboundid.ldap.sdk.CompareResult;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResponseAcceptor;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import java.util.logging.Level;

@InternalUseOnly
final class AsyncCompareHelper
implements ResponseAcceptor,
IntermediateResponseListener {
    private static final long serialVersionUID = 8888333889563000881L;
    private final AsyncCompareResultListener resultListener;
    private final IntermediateResponseListener intermediateResponseListener;
    private final LDAPConnection connection;
    private final long createTime;

    @InternalUseOnly
    AsyncCompareHelper(LDAPConnection connection, AsyncCompareResultListener resultListener, IntermediateResponseListener intermediateResponseListener) {
        this.connection = connection;
        this.resultListener = resultListener;
        this.intermediateResponseListener = intermediateResponseListener;
        this.createTime = System.nanoTime();
    }

    @InternalUseOnly
    public void responseReceived(LDAPResponse response) throws LDAPException {
        if (response instanceof ConnectionClosedResponse) {
            ConnectionClosedResponse ccr = (ConnectionClosedResponse)response;
            String message = ccr.getMessage();
            if (message == null) {
                throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE.get());
            }
            throw new LDAPException(ccr.getResultCode(), LDAPMessages.ERR_CONN_CLOSED_WAITING_FOR_ASYNC_RESPONSE_WITH_MESSAGE.get(message));
        }
        this.connection.getConnectionStatistics().incrementNumCompareResponses(System.nanoTime() - this.createTime);
        CompareResult result = (CompareResult)response;
        this.resultListener.compareResultReceived(new AsyncRequestID(result.getMessageID()), result);
    }

    @InternalUseOnly
    public void intermediateResponseReturned(IntermediateResponse intermediateResponse) {
        if (this.intermediateResponseListener == null) {
            Debug.debug(Level.WARNING, DebugType.LDAP, LDAPMessages.WARN_INTERMEDIATE_RESPONSE_WITH_NO_LISTENER.get(String.valueOf(intermediateResponse)));
        } else {
            this.intermediateResponseListener.intermediateResponseReturned(intermediateResponse);
        }
    }
}

