/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SingleServerSet;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.List;
import javax.net.SocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class FailoverServerSet
extends ServerSet {
    private final ServerSet[] serverSets;

    public FailoverServerSet(String[] addresses, int[] ports) {
        this(addresses, ports, null, null);
    }

    public FailoverServerSet(String[] addresses, int[] ports, LDAPConnectionOptions connectionOptions) {
        this(addresses, ports, null, connectionOptions);
    }

    public FailoverServerSet(String[] addresses, int[] ports, SocketFactory socketFactory) {
        this(addresses, ports, socketFactory, null);
    }

    public FailoverServerSet(String[] addresses, int[] ports, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions) {
        Validator.ensureNotNull(addresses, ports);
        Validator.ensureTrue(addresses.length > 0, "FailoverServerSet.addresses must not be empty.");
        Validator.ensureTrue(addresses.length == ports.length, "FailoverServerSet addresses and ports arrays must be the same size.");
        SocketFactory sf = socketFactory == null ? SocketFactory.getDefault() : socketFactory;
        LDAPConnectionOptions co = connectionOptions == null ? new LDAPConnectionOptions() : connectionOptions;
        this.serverSets = new ServerSet[addresses.length];
        for (int i = 0; i < this.serverSets.length; ++i) {
            this.serverSets[i] = new SingleServerSet(addresses[i], ports[i], sf, co);
        }
    }

    public FailoverServerSet(ServerSet ... serverSets) {
        Validator.ensureNotNull(serverSets);
        Validator.ensureFalse(serverSets.length == 0, "FailoverServerSet.serverSets must not be empty.");
        this.serverSets = serverSets;
    }

    public FailoverServerSet(List<ServerSet> serverSets) {
        Validator.ensureNotNull(serverSets);
        Validator.ensureFalse(serverSets.isEmpty(), "FailoverServerSet.serverSets must not be empty.");
        this.serverSets = new ServerSet[serverSets.size()];
        serverSets.toArray(this.serverSets);
    }

    public ServerSet[] getServerSets() {
        return this.serverSets;
    }

    @Override
    public LDAPConnection getConnection() throws LDAPException {
        return this.getConnection(null);
    }

    @Override
    public LDAPConnection getConnection(LDAPConnectionPoolHealthCheck healthCheck) throws LDAPException {
        LDAPException lastException = null;
        for (ServerSet s : this.serverSets) {
            try {
                return s.getConnection(healthCheck);
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                lastException = le;
            }
        }
        throw lastException;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("FailoverServerSet(serverSets={");
        for (int i = 0; i < this.serverSets.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            this.serverSets[i].toString(buffer);
        }
        buffer.append("})");
    }
}

