/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import javax.net.SocketFactory;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class RoundRobinServerSet
extends ServerSet {
    private final int[] ports;
    private final LDAPConnectionOptions connectionOptions;
    private final SocketFactory socketFactory;
    private final String[] addresses;
    private int nextSlot;

    public RoundRobinServerSet(String[] addresses, int[] ports) {
        this(addresses, ports, null, null);
    }

    public RoundRobinServerSet(String[] addresses, int[] ports, LDAPConnectionOptions connectionOptions) {
        this(addresses, ports, null, connectionOptions);
    }

    public RoundRobinServerSet(String[] addresses, int[] ports, SocketFactory socketFactory) {
        this(addresses, ports, socketFactory, null);
    }

    public RoundRobinServerSet(String[] addresses, int[] ports, SocketFactory socketFactory, LDAPConnectionOptions connectionOptions) {
        Validator.ensureNotNull(addresses, ports);
        Validator.ensureTrue(addresses.length > 0, "RoundRobinServerSet.addresses must not be empty.");
        Validator.ensureTrue(addresses.length == ports.length, "RoundRobinServerSet addresses and ports arrays must be the same size.");
        this.addresses = addresses;
        this.ports = ports;
        this.socketFactory = socketFactory == null ? SocketFactory.getDefault() : socketFactory;
        this.connectionOptions = connectionOptions == null ? new LDAPConnectionOptions() : connectionOptions;
        this.nextSlot = 0;
    }

    public String[] getAddresses() {
        return this.addresses;
    }

    public int[] getPorts() {
        return this.ports;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public LDAPConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    public synchronized LDAPConnection getConnection() throws LDAPException {
        return this.getConnection(null);
    }

    public LDAPConnection getConnection(LDAPConnectionPoolHealthCheck healthCheck) throws LDAPException {
        int initialSlotNumber = this.nextSlot++;
        if (this.nextSlot >= this.addresses.length) {
            this.nextSlot = 0;
        }
        try {
            LDAPConnection c = new LDAPConnection(this.socketFactory, this.connectionOptions, this.addresses[initialSlotNumber], this.ports[initialSlotNumber]);
            if (healthCheck != null) {
                try {
                    healthCheck.ensureNewConnectionValid(c);
                }
                catch (LDAPException le) {
                    c.close();
                    throw le;
                }
            }
            return c;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            LDAPException lastException = le;
            while (this.nextSlot != initialSlotNumber) {
                ++this.nextSlot;
                if (this.nextSlot >= this.addresses.length) {
                    this.nextSlot = 0;
                }
                try {
                    int slotNumber;
                    LDAPConnection c = new LDAPConnection(this.socketFactory, this.connectionOptions, this.addresses[slotNumber], this.ports[slotNumber]);
                    if (healthCheck != null) {
                        try {
                            healthCheck.ensureNewConnectionValid(c);
                        }
                        catch (LDAPException le2) {
                            c.close();
                            throw le2;
                        }
                    }
                    return c;
                }
                catch (LDAPException le2) {
                    Debug.debugException(le2);
                    lastException = le2;
                }
            }
            throw lastException;
        }
    }

    public void toString(StringBuilder buffer) {
        buffer.append("RoundRobinServerSet(servers={");
        for (int i = 0; i < this.addresses.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.addresses[i]);
            buffer.append(':');
            buffer.append(this.ports[i]);
        }
        buffer.append("})");
    }
}

