/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DecodeableControl;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ContentSyncDoneControl
extends Control
implements DecodeableControl {
    public static final String SYNC_DONE_OID = "1.3.6.1.4.1.4203.1.9.1.3";
    private static final long serialVersionUID = -2723009401737612274L;
    private final ASN1OctetString cookie;
    private final boolean refreshDeletes;

    ContentSyncDoneControl() {
        this.cookie = null;
        this.refreshDeletes = false;
    }

    public ContentSyncDoneControl(ASN1OctetString cookie, boolean refreshDeletes) {
        super(SYNC_DONE_OID, false, ContentSyncDoneControl.encodeValue(cookie, refreshDeletes));
        this.cookie = cookie;
        this.refreshDeletes = refreshDeletes;
    }

    public ContentSyncDoneControl(String oid, boolean isCritical, ASN1OctetString value) throws LDAPException {
        super(oid, isCritical, value);
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SYNC_DONE_NO_VALUE.get());
        }
        ASN1OctetString c = null;
        Boolean r = null;
        try {
            ASN1Sequence s = ASN1Sequence.decodeAsSequence(value.getValue());
            block7: for (ASN1Element e : s.elements()) {
                switch (e.getType()) {
                    case 4: {
                        if (c == null) {
                            c = ASN1OctetString.decodeAsOctetString(e);
                            continue block7;
                        }
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SYNC_DONE_VALUE_MULTIPLE_COOKIES.get());
                    }
                    case 1: {
                        if (r == null) {
                            r = ASN1Boolean.decodeAsBoolean(e).booleanValue();
                            continue block7;
                        }
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SYNC_DONE_VALUE_MULTIPLE_REFRESH_DELETE.get());
                    }
                    default: {
                        throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SYNC_DONE_VALUE_INVALID_ELEMENT_TYPE.get(StaticUtils.toHex(e.getType())));
                    }
                }
            }
        }
        catch (LDAPException le) {
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_SYNC_DONE_VALUE_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
        this.cookie = c;
        this.refreshDeletes = r == null ? false : r;
    }

    private static ASN1OctetString encodeValue(ASN1OctetString cookie, boolean refreshDeletes) {
        ArrayList<ASN1Element> elements = new ArrayList<ASN1Element>(2);
        if (cookie != null) {
            elements.add(cookie);
        }
        if (refreshDeletes) {
            elements.add(new ASN1Boolean(refreshDeletes));
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    public ContentSyncDoneControl decodeControl(String oid, boolean isCritical, ASN1OctetString value) throws LDAPException {
        return new ContentSyncDoneControl(oid, isCritical, value);
    }

    public ASN1OctetString getCookie() {
        return this.cookie;
    }

    public boolean refreshDeletes() {
        return this.refreshDeletes;
    }

    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_CONTENT_SYNC_DONE.get();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ContentSyncDoneControl(");
        if (this.cookie != null) {
            buffer.append("cookie=");
            StaticUtils.toHex(this.cookie.getValue(), buffer);
            buffer.append(", ");
        }
        buffer.append("refreshDeletes=");
        buffer.append(this.refreshDeletes);
        buffer.append(')');
    }
}

