/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ProxiedAuthorizationV1RequestControl
extends Control {
    public static final String PROXIED_AUTHORIZATION_V1_REQUEST_OID = "2.16.840.1.113730.3.4.12";
    private static final long serialVersionUID = 7312632337431962774L;
    private final String proxyDN;

    public ProxiedAuthorizationV1RequestControl(String proxyDN) {
        super(PROXIED_AUTHORIZATION_V1_REQUEST_OID, true, ProxiedAuthorizationV1RequestControl.encodeValue(proxyDN));
        Validator.ensureNotNull(proxyDN);
        this.proxyDN = proxyDN;
    }

    public ProxiedAuthorizationV1RequestControl(DN proxyDN) {
        super(PROXIED_AUTHORIZATION_V1_REQUEST_OID, true, ProxiedAuthorizationV1RequestControl.encodeValue(proxyDN.toString()));
        this.proxyDN = proxyDN.toString();
    }

    public ProxiedAuthorizationV1RequestControl(Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PROXY_V1_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(valueElement).elements();
            this.proxyDN = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_PROXYV1_DECODE_ERROR.get(e), e);
        }
    }

    private static ASN1OctetString encodeValue(String proxyDN) {
        ASN1Element[] valueElements = new ASN1Element[]{new ASN1OctetString(proxyDN)};
        return new ASN1OctetString(new ASN1Sequence(valueElements).encode());
    }

    public String getProxyDN() {
        return this.proxyDN;
    }

    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_PROXIED_AUTHZ_V1_REQUEST.get();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ProxiedAuthorizationV1RequestControl(proxyDN=");
        buffer.append(this.proxyDN);
        buffer.append(')');
    }
}

