/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.schema;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.SchemaElement;
import com.unboundid.ldap.sdk.schema.SchemaMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class MatchingRuleDefinition
extends SchemaElement {
    private static final String[] NO_STRINGS = new String[0];
    private static final long serialVersionUID = 8214648655449007967L;
    private final boolean isObsolete;
    private final Map<String, String[]> extensions;
    private final String description;
    private final String matchingRuleString;
    private final String oid;
    private final String syntaxOID;
    private final String[] names;

    public MatchingRuleDefinition(String s) throws LDAPException {
        LinkedHashMap<String, String[]> exts;
        String synOID;
        Boolean obsolete;
        String descr;
        ArrayList<String> nameList;
        block16: {
            String token;
            Validator.ensureNotNull(s);
            this.matchingRuleString = s.trim();
            int length = this.matchingRuleString.length();
            if (length == 0) {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_EMPTY.get());
            }
            if (this.matchingRuleString.charAt(0) != '(') {
                throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_NO_OPENING_PAREN.get(this.matchingRuleString));
            }
            int pos = MatchingRuleDefinition.skipSpaces(this.matchingRuleString, 1, length);
            StringBuilder buffer = new StringBuilder();
            pos = MatchingRuleDefinition.readOID(this.matchingRuleString, pos, length, buffer);
            this.oid = buffer.toString();
            nameList = new ArrayList<String>(1);
            descr = null;
            obsolete = null;
            synOID = null;
            exts = new LinkedHashMap<String, String[]>();
            while (true) {
                int tokenStartPos = pos = MatchingRuleDefinition.skipSpaces(this.matchingRuleString, pos, length);
                while (pos < length && this.matchingRuleString.charAt(pos) != ' ') {
                    ++pos;
                }
                token = this.matchingRuleString.substring(tokenStartPos, pos);
                String lowerToken = StaticUtils.toLowerCase(token);
                if (lowerToken.equals(")")) {
                    if (pos < length) {
                        throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_CLOSE_NOT_AT_END.get(this.matchingRuleString));
                    }
                    break block16;
                }
                if (lowerToken.equals("name")) {
                    if (nameList.isEmpty()) {
                        pos = MatchingRuleDefinition.skipSpaces(this.matchingRuleString, pos, length);
                        pos = MatchingRuleDefinition.readQDStrings(this.matchingRuleString, pos, length, nameList);
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_MULTIPLE_ELEMENTS.get(this.matchingRuleString, "NAME"));
                }
                if (lowerToken.equals("desc")) {
                    if (descr == null) {
                        pos = MatchingRuleDefinition.skipSpaces(this.matchingRuleString, pos, length);
                        buffer = new StringBuilder();
                        pos = MatchingRuleDefinition.readQDString(this.matchingRuleString, pos, length, buffer);
                        descr = buffer.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_MULTIPLE_ELEMENTS.get(this.matchingRuleString, "DESC"));
                }
                if (lowerToken.equals("obsolete")) {
                    if (obsolete == null) {
                        obsolete = true;
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_MULTIPLE_ELEMENTS.get(this.matchingRuleString, "OBSOLETE"));
                }
                if (lowerToken.equals("syntax")) {
                    if (synOID == null) {
                        pos = MatchingRuleDefinition.skipSpaces(this.matchingRuleString, pos, length);
                        buffer = new StringBuilder();
                        pos = MatchingRuleDefinition.readOID(this.matchingRuleString, pos, length, buffer);
                        synOID = buffer.toString();
                        continue;
                    }
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_MULTIPLE_ELEMENTS.get(this.matchingRuleString, "SYNTAX"));
                }
                if (!lowerToken.startsWith("x-")) break;
                pos = MatchingRuleDefinition.skipSpaces(this.matchingRuleString, pos, length);
                ArrayList<String> valueList = new ArrayList<String>();
                pos = MatchingRuleDefinition.readQDStrings(this.matchingRuleString, pos, length, valueList);
                String[] values = new String[valueList.size()];
                valueList.toArray(values);
                if (exts.containsKey(token)) {
                    throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_DUP_EXT.get(this.matchingRuleString, token));
                }
                exts.put(token, values);
            }
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_UNEXPECTED_TOKEN.get(this.matchingRuleString, token));
        }
        this.description = descr;
        this.syntaxOID = synOID;
        if (this.syntaxOID == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, SchemaMessages.ERR_MR_DECODE_NO_SYNTAX.get(this.matchingRuleString));
        }
        this.names = new String[nameList.size()];
        nameList.toArray(this.names);
        this.isObsolete = obsolete != null;
        this.extensions = Collections.unmodifiableMap(exts);
    }

    public MatchingRuleDefinition(String oid, String[] names, String description, boolean isObsolete, String syntaxOID, Map<String, String[]> extensions) {
        Validator.ensureNotNull(oid, syntaxOID);
        this.oid = oid;
        this.description = description;
        this.isObsolete = isObsolete;
        this.syntaxOID = syntaxOID;
        this.names = names == null ? NO_STRINGS : names;
        this.extensions = extensions == null ? Collections.emptyMap() : Collections.unmodifiableMap(extensions);
        StringBuilder buffer = new StringBuilder();
        this.createDefinitionString(buffer);
        this.matchingRuleString = buffer.toString();
    }

    private void createDefinitionString(StringBuilder buffer) {
        buffer.append("( ");
        buffer.append(this.oid);
        if (this.names.length == 1) {
            buffer.append(" NAME '");
            buffer.append(this.names[0]);
            buffer.append('\'');
        } else if (this.names.length > 1) {
            buffer.append(" NAME (");
            for (String name : this.names) {
                buffer.append(" '");
                buffer.append(name);
                buffer.append('\'');
            }
            buffer.append(" )");
        }
        if (this.description != null) {
            buffer.append(" DESC '");
            MatchingRuleDefinition.encodeValue(this.description, buffer);
            buffer.append('\'');
        }
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        buffer.append(" SYNTAX ");
        buffer.append(this.syntaxOID);
        for (Map.Entry<String, String[]> e : this.extensions.entrySet()) {
            String name = e.getKey();
            String[] values = e.getValue();
            if (values.length == 1) {
                buffer.append(' ');
                buffer.append(name);
                buffer.append(" '");
                MatchingRuleDefinition.encodeValue(values[0], buffer);
                buffer.append('\'');
                continue;
            }
            buffer.append(' ');
            buffer.append(name);
            buffer.append(" (");
            for (String value : values) {
                buffer.append(" '");
                MatchingRuleDefinition.encodeValue(value, buffer);
                buffer.append('\'');
            }
            buffer.append(" )");
        }
        buffer.append(" )");
    }

    public String getOID() {
        return this.oid;
    }

    public String[] getNames() {
        return this.names;
    }

    public String getNameOrOID() {
        if (this.names.length == 0) {
            return this.oid;
        }
        return this.names[0];
    }

    public boolean hasNameOrOID(String s) {
        for (String name : this.names) {
            if (!s.equalsIgnoreCase(name)) continue;
            return true;
        }
        return s.equalsIgnoreCase(this.oid);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public String getSyntaxOID() {
        return this.syntaxOID;
    }

    public Map<String, String[]> getExtensions() {
        return this.extensions;
    }

    @Override
    public String toString() {
        return this.matchingRuleString;
    }
}

