/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.Mutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class BooleanArgument
extends Argument {
    private static final long serialVersionUID = -3366354214909534696L;

    public BooleanArgument(Character shortIdentifier, String longIdentifier, String description) throws ArgumentException {
        super(shortIdentifier, longIdentifier, false, 1, null, description);
    }

    public BooleanArgument(Character shortIdentifier, String longIdentifier, int maxOccurrences, String description) throws ArgumentException {
        super(shortIdentifier, longIdentifier, false, maxOccurrences, null, description);
    }

    protected void addValue(String valueString) throws ArgumentException {
        throw new ArgumentException(ArgsMessages.ERR_BOOLEAN_VALUES_NOT_ALLOWED.get(this.getIdentifierString()));
    }

    protected boolean hasDefaultValue() {
        return false;
    }

    public String getDataTypeName() {
        return ArgsMessages.INFO_BOOLEAN_TYPE_NAME.get();
    }

    public String getValueConstraints() {
        return ArgsMessages.INFO_BOOLEAN_CONSTRAINTS.get();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("BooleanArgument(");
        this.appendBasicToStringInfo(buffer);
        buffer.append(')');
    }
}

