/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import java.util.Collection;
import org.mvel2.CompileException;
import org.mvel2.ast.ASTNode;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.integration.impl.DefaultLocalVariableResolverFactory;
import org.mvel2.integration.impl.ItemResolverFactory;
import org.mvel2.util.CompilerTools;
import org.mvel2.util.FastList;
import org.mvel2.util.ParseTools;

public class Fold
extends ASTNode {
    private ExecutableStatement subEx;
    private ExecutableStatement dataEx;
    private ExecutableStatement constraintEx;

    public Fold(char[] name, int fields) {
        int cursor;
        this.name = name;
        for (cursor = 0; cursor < name.length; ++cursor) {
            if (!ParseTools.isWhitespace(name[cursor])) continue;
            while (cursor < name.length && ParseTools.isWhitespace(name[cursor])) {
                ++cursor;
            }
            if (name[cursor] == 'i' && name[cursor + 1] == 'n' && ParseTools.isJunct(name[cursor + 2])) break;
        }
        this.subEx = (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.subset(name, 0, cursor - 1));
        int start = cursor += 2;
        while (cursor < name.length) {
            if (ParseTools.isWhitespace(name[cursor])) {
                while (cursor < name.length && ParseTools.isWhitespace(name[cursor])) {
                    ++cursor;
                }
                if (name[cursor] == 'i' && name[cursor + 1] == 'f' && ParseTools.isJunct(name[cursor + 2])) {
                    int s = cursor + 2;
                    this.constraintEx = (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.subset(name, s, name.length - s));
                    break;
                }
            }
            ++cursor;
        }
        this.dataEx = (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.subset(name, start, cursor - start));
        CompilerTools.expectType(this.dataEx, Collection.class, (fields & 0x10) != 0);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        FastList list;
        ItemResolverFactory.ItemResolver itemR = new ItemResolverFactory.ItemResolver("$");
        ItemResolverFactory itemFactory = new ItemResolverFactory(itemR, new DefaultLocalVariableResolverFactory(factory));
        if (this.constraintEx != null) {
            Collection col = (Collection)this.dataEx.getValue(ctx, thisValue, factory);
            list = new FastList(col.size());
            for (Object o : col) {
                itemR.value = o;
                if (!((Boolean)this.constraintEx.getValue(ctx, thisValue, itemFactory)).booleanValue()) continue;
                list.add(this.subEx.getValue(o, thisValue, itemFactory));
            }
        } else {
            Collection col = (Collection)this.dataEx.getValue(ctx, thisValue, factory);
            list = new FastList(col.size());
            for (Object o : col) {
                itemR.value = o;
                list.add(this.subEx.getValue(itemR.value, thisValue, itemFactory));
            }
        }
        return list;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        FastList list;
        ItemResolverFactory.ItemResolver itemR = new ItemResolverFactory.ItemResolver("$");
        ItemResolverFactory itemFactory = new ItemResolverFactory(itemR, new DefaultLocalVariableResolverFactory(factory));
        if (this.constraintEx != null) {
            Object x = this.dataEx.getValue(ctx, thisValue, factory);
            if (!(x instanceof Collection)) {
                throw new CompileException("was expecting type: Collection; but found type: " + (x == null ? "null" : x.getClass().getName()));
            }
            list = new FastList(((Collection)x).size());
            for (Object o : (Collection)x) {
                itemR.value = o;
                if (!((Boolean)this.constraintEx.getValue(ctx, thisValue, itemFactory)).booleanValue()) continue;
                list.add(this.subEx.getValue(o, thisValue, itemFactory));
            }
        } else {
            Object x = this.dataEx.getValue(ctx, thisValue, factory);
            if (!(x instanceof Collection)) {
                throw new CompileException("was expecting type: Collection; but found type: " + (x == null ? "null" : x.getClass().getName()));
            }
            list = new FastList(((Collection)x).size());
            for (Object o : (Collection)x) {
                itemR.value = o;
                list.add(this.subEx.getValue(itemR.value, thisValue, itemFactory));
            }
        }
        return list;
    }

    public Class getEgressType() {
        return Collection.class;
    }
}

