/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.mvel2.CompileException;
import org.mvel2.MVEL;
import org.mvel2.ast.ASTNode;
import org.mvel2.compiler.ExecutableLiteral;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ParseTools;

public class RegExMatch
extends ASTNode {
    private ExecutableStatement stmt;
    private ExecutableStatement patternStmt;
    private char[] pattern;
    private Pattern p;

    public RegExMatch(char[] expr, int fields, char[] pattern) {
        this.name = expr;
        this.pattern = pattern;
        if ((fields & 0x10) != 0) {
            this.stmt = (ExecutableStatement)ParseTools.subCompileExpression(expr);
            this.patternStmt = (ExecutableStatement)ParseTools.subCompileExpression(pattern);
            if (this.patternStmt instanceof ExecutableLiteral) {
                try {
                    this.p = Pattern.compile(String.valueOf(this.patternStmt.getValue(null, null)));
                }
                catch (PatternSyntaxException e) {
                    throw new CompileException("bad regular expression", e);
                }
            }
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.p == null) {
            return Pattern.compile(String.valueOf(this.patternStmt.getValue(ctx, thisValue, factory))).matcher(String.valueOf(this.stmt.getValue(ctx, thisValue, factory))).matches();
        }
        return this.p.matcher(String.valueOf(this.stmt.getValue(ctx, thisValue, factory))).matches();
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            return Pattern.compile(String.valueOf(MVEL.eval(this.pattern, ctx, factory))).matcher(String.valueOf(MVEL.eval(this.name, ctx, factory))).matches();
        }
        catch (PatternSyntaxException e) {
            throw new CompileException("bad regular expression", e);
        }
    }

    public Class getEgressType() {
        return Boolean.class;
    }
}

