/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.util;

import org.mvel2.CompileException;
import org.mvel2.util.StackElement;
import org.mvel2.util.StringAppender;

public class ExecutionStack {
    private StackElement element;
    private int size = 0;

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void add(Object o) {
        ++this.size;
        StackElement el = this.element;
        if (el != null) {
            while (el.next != null) {
                el = el.next;
            }
            el.next = new StackElement(null, o);
        } else {
            this.element = new StackElement(null, o);
        }
    }

    public void push(Object o) {
        ++this.size;
        this.element = new StackElement(this.element, o);
    }

    public Object pushAndPeek(Object o) {
        ++this.size;
        this.element = new StackElement(this.element, o);
        return o;
    }

    public void push(Object obj1, Object obj2) {
        this.size += 2;
        this.element = new StackElement(new StackElement(this.element, obj1), obj2);
    }

    public void push(Object obj1, Object obj2, Object obj3) {
        this.size += 3;
        this.element = new StackElement(new StackElement(new StackElement(this.element, obj1), obj2), obj3);
    }

    public Object peek() {
        if (this.size == 0) {
            return null;
        }
        return this.element.value;
    }

    public Boolean peekBoolean() {
        if (this.size == 0) {
            return null;
        }
        if (this.element.value instanceof Boolean) {
            return (Boolean)this.element.value;
        }
        throw new CompileException("expected Boolean; but found: " + (this.element.value == null ? "null" : this.element.value.getClass().getName()));
    }

    public Object peek2() {
        return this.element.next.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pop() {
        if (this.size-- == 0) {
            return null;
        }
        try {
            Object object = this.element.value;
            return object;
        }
        finally {
            this.element = this.element.next;
        }
    }

    public Boolean popBoolean() {
        if (this.size-- == 0) {
            return null;
        }
        try {
            if (this.element.value instanceof Boolean) {
                Boolean bl = (Boolean)this.element.value;
                return bl;
            }
            throw new CompileException("expected Boolean; but found: " + (this.element.value == null ? "null" : this.element.value.getClass().getName()));
        }
        finally {
            this.element = this.element.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pop2() {
        try {
            this.size -= 2;
            Object object = this.element.value;
            return object;
        }
        finally {
            this.element = this.element.next.next;
        }
    }

    public void discard() {
        if (this.size != 0) {
            --this.size;
            this.element = this.element.next;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isReduceable() {
        return this.size > 1;
    }

    public void clear() {
        this.size = 0;
        this.element = null;
    }

    public String toString() {
        StackElement el = this.element;
        if (this.element == null) {
            return "<EMPTY>";
        }
        StringAppender appender = new StringAppender().append("[");
        do {
            appender.append(String.valueOf(el.value));
            if (el.next == null) continue;
            appender.append(", ");
        } while ((el = el.next) != null);
        appender.append("]");
        return appender.toString();
    }
}

