/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.matching;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Relationship;
import org.neo4j.commons.iterator.FilteringIterable;
import org.neo4j.util.matching.NeoArrayPropertyUtil;
import org.neo4j.util.matching.PatternElement;
import org.neo4j.util.matching.PatternGroup;
import org.neo4j.util.matching.PatternMatch;
import org.neo4j.util.matching.PatternNode;
import org.neo4j.util.matching.PatternPosition;
import org.neo4j.util.matching.PatternRelationship;
import org.neo4j.util.matching.filter.AbstractFilterExpression;
import org.neo4j.util.matching.filter.FilterBinaryNode;
import org.neo4j.util.matching.filter.FilterExpression;
import org.neo4j.util.matching.filter.FilterValueGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternMatcher {
    private static PatternMatcher matcher = new PatternMatcher();

    private PatternMatcher() {
    }

    public static PatternMatcher getMatcher() {
        return matcher;
    }

    public Iterable<PatternMatch> match(PatternNode start, Node startNode) {
        return this.match(start, startNode, null);
    }

    public Iterable<PatternMatch> match(PatternNode start, Node startNode, Map<String, PatternNode> objectVariables) {
        return this.match(start, startNode, objectVariables, (Collection<PatternNode>)null);
    }

    public Iterable<PatternMatch> match(PatternNode start, Node startNode, Map<String, PatternNode> objectVariables, Collection<PatternNode> optional) {
        Object result = null;
        result = optional == null || optional.size() < 1 ? new PatternFinder(start, startNode) : new PatternFinder(start, startNode, false, optional);
        if (objectVariables != null) {
            result = new FilteredPatternFinder((Iterable<PatternMatch>)result, objectVariables);
        }
        return result;
    }

    public Iterable<PatternMatch> match(PatternNode start, Node startNode, Map<String, PatternNode> objectVariables, PatternNode ... optional) {
        return this.match(start, startNode, objectVariables, Arrays.asList(optional));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PatternFinder
    implements Iterable<PatternMatch>,
    Iterator<PatternMatch> {
        private Set<Relationship> visitedRels = new HashSet<Relationship>();
        private PatternPosition currentPosition;
        private OptionalPatternFinder optionalFinder;
        private PatternNode startPatternNode;
        private Node startNode;
        private Collection<PatternNode> optionalNodes;
        private boolean optional;
        private Stack<CallPosition> callStack = new Stack();
        private Stack<PatternPosition> uncompletedPositions = new Stack();
        private Stack<PatternElement> foundElements = new Stack();
        private PatternMatch match = null;
        private PatternMatch optionalMatch = null;

        PatternFinder(PatternNode start, Node startNode) {
            this(start, startNode, false);
        }

        PatternFinder(PatternNode start, Node startNode, boolean optional) {
            this.startPatternNode = start;
            this.startNode = startNode;
            this.currentPosition = new PatternPosition(startNode, start, optional);
            this.optional = optional;
        }

        PatternFinder(PatternNode start, Node startNode, boolean optional, PatternNode ... optionalNodes) {
            this(start, startNode, optional, Arrays.asList(optionalNodes));
        }

        PatternFinder(PatternNode start, Node startNode, boolean optional, Collection<PatternNode> optionalNodes) {
            this(start, startNode, optional);
            this.optionalNodes = optionalNodes;
        }

        PatternNode getStartPatternNode() {
            return this.startPatternNode;
        }

        Node getStartNode() {
            return this.startNode;
        }

        private PatternMatch findNextMatch() {
            if (this.callStack.isEmpty() && this.currentPosition != null) {
                if (this.traverse(this.currentPosition, true)) {
                    this.currentPosition = null;
                    HashMap<PatternNode, PatternElement> filteredElements = new HashMap<PatternNode, PatternElement>();
                    HashMap<PatternRelationship, Relationship> relElements = new HashMap<PatternRelationship, Relationship>();
                    for (PatternElement element : this.foundElements) {
                        filteredElements.put(element.getPatternNode(), element);
                        relElements.put(element.getFromPatternRelationship(), element.getFromRelationship());
                    }
                    PatternMatch patternMatch = new PatternMatch(filteredElements, relElements);
                    this.foundElements.pop();
                    return patternMatch;
                }
                this.currentPosition = null;
            } else if (!this.callStack.isEmpty()) {
                boolean matchFound = false;
                do {
                    CallPosition callStackInformation = this.callStack.peek();
                    matchFound = this.traverse(callStackInformation);
                } while (!this.callStack.isEmpty() && !matchFound);
                if (matchFound) {
                    HashMap<PatternNode, PatternElement> filteredElements = new HashMap<PatternNode, PatternElement>();
                    HashMap<PatternRelationship, Relationship> relElements = new HashMap<PatternRelationship, Relationship>();
                    for (PatternElement element : this.foundElements) {
                        filteredElements.put(element.getPatternNode(), element);
                        relElements.put(element.getFromPatternRelationship(), element.getFromRelationship());
                    }
                    PatternMatch patternMatch = new PatternMatch(filteredElements, relElements);
                    this.foundElements.pop();
                    return patternMatch;
                }
            }
            return null;
        }

        private boolean traverse(CallPosition callPos) {
            PatternPosition currentPos = callPos.getPatternPosition();
            PatternRelationship pRel = callPos.getPatternRelationship();
            pRel.mark();
            this.visitedRels.remove(callPos.getLastVisitedRelationship());
            Node currentNode = currentPos.getCurrentNode();
            Iterator<Relationship> relItr = callPos.getRelationshipIterator();
            while (relItr.hasNext()) {
                Relationship rel = relItr.next();
                if (this.visitedRels.contains(rel) || !this.checkProperties(pRel, rel)) continue;
                Node otherNode = rel.getOtherNode(currentNode);
                PatternNode otherPosition = pRel.getOtherNode(currentPos.getPatternNode());
                pRel.mark();
                this.visitedRels.add(rel);
                if (this.traverse(new PatternPosition(otherNode, otherPosition, pRel, rel, this.optional), true)) {
                    callPos.setLastVisitedRelationship(rel);
                    return true;
                }
                this.visitedRels.remove(rel);
                pRel.unMark();
            }
            pRel.unMark();
            if (callPos.shouldPopUncompleted()) {
                this.uncompletedPositions.pop();
            }
            this.callStack.pop();
            this.foundElements.pop();
            return false;
        }

        private boolean traverse(PatternPosition currentPos, boolean pushElement) {
            Node currentNode;
            PatternNode pNode = currentPos.getPatternNode();
            if (!this.checkProperties(pNode, currentNode = currentPos.getCurrentNode())) {
                return false;
            }
            if (pushElement) {
                this.foundElements.push(new PatternElement(currentPos.getPatternNode(), currentPos.fromPatternRel(), currentPos.getCurrentNode(), currentPos.fromRelationship()));
            }
            if (currentPos.hasNext()) {
                boolean popUncompleted = false;
                PatternRelationship pRel = currentPos.next();
                if (currentPos.hasNext()) {
                    this.uncompletedPositions.push(currentPos);
                    popUncompleted = true;
                }
                assert (!pRel.isMarked());
                Iterator<Relationship> relItr = this.getRelationshipIterator(currentPos.getPatternNode(), currentNode, pRel);
                pRel.mark();
                while (relItr.hasNext()) {
                    Relationship rel = relItr.next();
                    if (this.visitedRels.contains(rel) || !this.checkProperties(pRel, rel)) continue;
                    Node otherNode = rel.getOtherNode(currentNode);
                    PatternNode otherPosition = pRel.getOtherNode(currentPos.getPatternNode());
                    this.visitedRels.add(rel);
                    CallPosition callPos = new CallPosition(currentPos, rel, relItr, pRel, popUncompleted);
                    this.callStack.push(callPos);
                    if (this.traverse(new PatternPosition(otherNode, otherPosition, pRel, rel, this.optional), true)) {
                        return true;
                    }
                    this.callStack.pop();
                    this.visitedRels.remove(rel);
                }
                pRel.unMark();
                if (popUncompleted) {
                    this.uncompletedPositions.pop();
                }
                this.foundElements.pop();
                return false;
            }
            boolean matchFound = true;
            if (!this.uncompletedPositions.isEmpty()) {
                PatternPosition digPos = this.uncompletedPositions.pop();
                digPos.reset();
                matchFound = this.traverse(digPos, false);
                this.uncompletedPositions.push(digPos);
                return matchFound;
            }
            return true;
        }

        private Iterator<Relationship> getRelationshipIterator(PatternNode fromNode, Node currentNode, PatternRelationship pRel) {
            Iterator<Object> relItr = null;
            relItr = pRel.anyRelType() ? currentNode.getRelationships(pRel.getDirectionFrom(fromNode)).iterator() : currentNode.getRelationships(pRel.getType(), pRel.getDirectionFrom(fromNode)).iterator();
            return relItr;
        }

        private boolean checkProperties(PatternNode patternNode, Node neoNode) {
            for (String propertyName : patternNode.getPropertiesExist()) {
                if (neoNode.hasProperty(propertyName)) continue;
                return false;
            }
            for (String propertyName : patternNode.getPropertiesEqual()) {
                if (this.neoPropertyHasValue(neoNode, patternNode, propertyName)) continue;
                return false;
            }
            return true;
        }

        private boolean checkProperties(PatternRelationship patternRel, Relationship neoRel) {
            for (String propertyName : patternRel.getPropertiesExist()) {
                if (neoRel.hasProperty(propertyName)) continue;
                return false;
            }
            for (String propertyName : patternRel.getPropertiesEqual()) {
                if (this.neoPropertyHasValue(neoRel, patternRel, propertyName)) continue;
                return false;
            }
            return true;
        }

        private boolean neoPropertyHasValue(Node neoNode, PatternNode patternNode, String propertyName) {
            if (!neoNode.hasProperty(propertyName)) {
                return false;
            }
            Object[] patternValues = patternNode.getPropertyValue(propertyName);
            Object neoValue = neoNode.getProperty(propertyName);
            Collection<Object> neoValues = NeoArrayPropertyUtil.neoValueToCollection(neoValue);
            neoValues.retainAll(Arrays.asList(patternValues));
            return !neoValues.isEmpty();
        }

        private boolean neoPropertyHasValue(Relationship neoRel, PatternRelationship patternRel, String propertyName) {
            if (!neoRel.hasProperty(propertyName)) {
                return false;
            }
            Object[] patternValues = patternRel.getPropertyValue(propertyName);
            Object neoValue = neoRel.getProperty(propertyName);
            Collection<Object> neoValues = NeoArrayPropertyUtil.neoValueToCollection(neoValue);
            neoValues.retainAll(Arrays.asList(patternValues));
            return !neoValues.isEmpty();
        }

        @Override
        public Iterator<PatternMatch> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            if (this.match == null) {
                this.match = this.findNextMatch();
                this.optionalFinder = null;
            } else if (this.optionalNodes != null) {
                if (this.optionalFinder == null) {
                    this.optionalFinder = new OptionalPatternFinder(this.match, this.optionalNodes);
                }
                if (this.optionalMatch == null) {
                    this.optionalMatch = this.optionalFinder.findNextOptionalPatterns();
                }
                if (this.optionalMatch == null && this.optionalFinder.anyMatchFound()) {
                    this.match = null;
                    return this.hasNext();
                }
            }
            return this.match != null;
        }

        @Override
        public PatternMatch next() {
            if (this.match == null) {
                this.match = this.findNextMatch();
                this.optionalFinder = null;
            }
            PatternMatch matchToReturn = this.match;
            PatternMatch optionalMatchToReturn = null;
            if (this.match != null && this.optionalNodes != null) {
                if (this.optionalFinder == null) {
                    this.optionalFinder = new OptionalPatternFinder(this.match, this.optionalNodes);
                }
                if (this.optionalMatch == null) {
                    this.optionalMatch = this.optionalFinder.findNextOptionalPatterns();
                }
                optionalMatchToReturn = this.optionalMatch;
                this.optionalMatch = null;
                if (optionalMatchToReturn == null) {
                    this.match = null;
                    if (this.optionalFinder.anyMatchFound()) {
                        return this.next();
                    }
                }
            } else {
                this.match = null;
            }
            if (matchToReturn == null) {
                throw new NoSuchElementException();
            }
            return optionalMatchToReturn != null ? PatternMatch.merge(matchToReturn, optionalMatchToReturn) : matchToReturn;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class CallPosition {
            private PatternPosition patternPosition;
            private Iterator<Relationship> relItr;
            private Relationship lastRel;
            private PatternRelationship currentPRel;
            private boolean popUncompleted;

            CallPosition(PatternPosition patternPosition, Relationship lastRel, Iterator<Relationship> relItr, PatternRelationship currentPRel, boolean popUncompleted) {
                this.patternPosition = patternPosition;
                this.relItr = relItr;
                this.lastRel = lastRel;
                this.currentPRel = currentPRel;
                this.popUncompleted = popUncompleted;
            }

            public void setLastVisitedRelationship(Relationship rel) {
                this.lastRel = rel;
            }

            public Relationship getLastVisitedRelationship() {
                return this.lastRel;
            }

            public boolean shouldPopUncompleted() {
                return this.popUncompleted;
            }

            public PatternPosition getPatternPosition() {
                return this.patternPosition;
            }

            public PatternRelationship getPatternRelationship() {
                return this.currentPRel;
            }

            public Iterator<Relationship> getRelationshipIterator() {
                return this.relItr;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteredPatternFinder
    extends FilteringIterable<PatternMatch> {
        private final Map<String, PatternNode> objectVariables;

        public FilteredPatternFinder(Iterable<PatternMatch> source, Map<String, PatternNode> objectVariables) {
            super(source);
            this.objectVariables = objectVariables;
        }

        protected boolean passes(PatternMatch item) {
            HashSet<PatternGroup> calculatedGroups = new HashSet<PatternGroup>();
            for (PatternElement element : item.getElements()) {
                PatternNode node = element.getPatternNode();
                PatternGroup group = node.getGroup();
                if (!calculatedGroups.add(group)) continue;
                SimpleRegexValueGetter valueGetter = new SimpleRegexValueGetter(this.objectVariables, item, group.getFilters());
                for (FilterExpression expression : group.getFilters()) {
                    if (expression.matches(valueGetter)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleRegexValueGetter
    implements FilterValueGetter {
        private PatternMatch match;
        private Map<String, PatternNode> labelToNode = new HashMap<String, PatternNode>();
        private Map<String, String> labelToProperty = new HashMap<String, String>();

        SimpleRegexValueGetter(Map<String, PatternNode> objectVariables, PatternMatch match, FilterExpression[] expressions) {
            this.match = match;
            for (FilterExpression expression : expressions) {
                this.mapFromExpression(expression);
            }
            this.labelToNode = objectVariables;
        }

        private void mapFromExpression(FilterExpression expression) {
            if (expression instanceof FilterBinaryNode) {
                FilterBinaryNode node = (FilterBinaryNode)expression;
                this.mapFromExpression(node.getLeftExpression());
                this.mapFromExpression(node.getRightExpression());
            } else {
                AbstractFilterExpression pattern = (AbstractFilterExpression)expression;
                this.labelToProperty.put(pattern.getLabel(), pattern.getProperty());
            }
        }

        public String[] getValues(String label) {
            PatternNode pNode = this.labelToNode.get(label);
            if (pNode == null) {
                throw new RuntimeException("No node for label '" + label + "'");
            }
            Node node = this.match.getNodeFor(pNode);
            String propertyKey = this.labelToProperty.get(label);
            if (propertyKey == null) {
                throw new RuntimeException("No property key for label '" + label + "'");
            }
            Object neoValue = node.getProperty(propertyKey, null);
            if (neoValue == null) {
                return new String[0];
            }
            Collection<Object> values = NeoArrayPropertyUtil.neoValueToCollection(neoValue);
            String[] result = new String[values.size()];
            int counter = 0;
            for (Object value : values) {
                result[counter++] = (String)value;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OptionalPatternFinder {
        private List<PatternFinder> optionalFinders;
        private List<PatternMatch> currentMatches;
        private Collection<PatternNode> optionalNodes;
        private PatternMatch baseMatch;
        private int position = -1;
        private boolean first = true;

        OptionalPatternFinder(PatternMatch baseMatch, Collection<PatternNode> optionalNodes) {
            this.baseMatch = baseMatch;
            this.optionalNodes = optionalNodes;
            this.initialize();
        }

        PatternMatch findNextOptionalPatterns() {
            if (this.position < 0) {
                return null;
            }
            if (this.first && this.anyMatchFound()) {
                this.first = false;
                return PatternMatch.merge(this.currentMatches);
            }
            boolean found = false;
            while (this.position >= 0) {
                if (this.optionalFinders.get(this.position).hasNext()) {
                    this.currentMatches.set(this.position, this.optionalFinders.get(this.position).next());
                    if (this.position < this.currentMatches.size() - 1) {
                        ++this.position;
                        this.reset(this.position);
                    }
                    found = true;
                    break;
                }
                --this.position;
            }
            if (!found) {
                return null;
            }
            return PatternMatch.merge(this.currentMatches);
        }

        boolean anyMatchFound() {
            return !this.currentMatches.isEmpty();
        }

        private void initialize() {
            this.optionalFinders = new ArrayList<PatternFinder>();
            this.currentMatches = new ArrayList<PatternMatch>();
            for (PatternNode node : this.optionalNodes) {
                PatternFinder finder = new PatternFinder(node, this.getNodeFor(node), true);
                if (!finder.hasNext()) continue;
                this.optionalFinders.add(finder);
                this.currentMatches.add(finder.next());
                ++this.position;
            }
        }

        private Node getNodeFor(PatternNode node) {
            for (PatternElement element : this.baseMatch.getElements()) {
                if (!node.getLabel().equals(element.getPatternNode().getLabel())) continue;
                return element.getNode();
            }
            throw new RuntimeException("Optional graph isn't connected to the main graph.");
        }

        private void reset(int fromIndex) {
            int i = fromIndex;
            while (i < this.optionalFinders.size()) {
                PatternFinder finder = this.optionalFinders.get(i);
                PatternFinder newFinder = new PatternFinder(finder.getStartPatternNode(), finder.getStartNode(), true);
                this.optionalFinders.set(i, newFinder);
                this.currentMatches.set(i, newFinder.next());
                this.position = i++;
            }
        }
    }
}

