/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.matching;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.util.matching.PatternNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternRelationship {
    private RelationshipType type;
    private PatternNode firstNode;
    private PatternNode secondNode;
    private boolean optional;
    private boolean isMarked = false;
    private boolean anyType = false;
    private Set<String> propertiesExist = new HashSet<String>();
    private Map<String, Object[]> propertiesEqual = new HashMap<String, Object[]>();

    PatternRelationship(PatternNode firstNode, PatternNode secondNode) {
        this(firstNode, secondNode, false);
    }

    PatternRelationship(RelationshipType type, PatternNode firstNode, PatternNode secondNode) {
        this(type, firstNode, secondNode, false);
    }

    PatternRelationship(PatternNode firstNode, PatternNode secondNode, boolean optional) {
        this.anyType = true;
        this.firstNode = firstNode;
        this.secondNode = secondNode;
        this.optional = optional;
    }

    PatternRelationship(RelationshipType type, PatternNode firstNode, PatternNode secondNode, boolean optional) {
        this.type = type;
        this.firstNode = firstNode;
        this.secondNode = secondNode;
        this.optional = optional;
    }

    boolean anyRelType() {
        return this.anyType;
    }

    public PatternNode getOtherNode(PatternNode node) {
        if (node == this.firstNode) {
            return this.secondNode;
        }
        if (node == this.secondNode) {
            return this.firstNode;
        }
        throw new RuntimeException("Node[" + node + "] not in this relationship");
    }

    public PatternNode getFirstNode() {
        return this.firstNode;
    }

    public PatternNode getSecondNode() {
        return this.secondNode;
    }

    public boolean isOptional() {
        return this.optional;
    }

    void mark() {
        this.isMarked = true;
    }

    void unMark() {
        this.isMarked = false;
    }

    boolean isMarked() {
        return this.isMarked;
    }

    public RelationshipType getType() {
        return this.type;
    }

    public void disconnect() {
        this.getFirstNode().removeRelationship(this, this.optional);
        this.getSecondNode().removeRelationship(this, this.optional);
        this.firstNode = null;
        this.secondNode = null;
    }

    public Direction getDirectionFrom(PatternNode fromNode) {
        if (fromNode.equals(this.firstNode)) {
            return Direction.OUTGOING;
        }
        if (fromNode.equals(this.secondNode)) {
            return Direction.INCOMING;
        }
        throw new RuntimeException(fromNode + " not in " + this);
    }

    public String toString() {
        return this.type + ":" + this.optional;
    }

    public void addPropertyExistConstraint(String propertyName) {
        this.propertiesExist.add(propertyName);
    }

    public void addPropertyEqualConstraint(String propertyName, Object ... atLeastOneOfTheseValues) {
        assert (atLeastOneOfTheseValues != null && atLeastOneOfTheseValues.length > 0);
        this.propertiesEqual.put(propertyName, atLeastOneOfTheseValues);
    }

    Set<String> getPropertiesExist() {
        return this.propertiesExist;
    }

    Set<String> getPropertiesEqual() {
        return this.propertiesEqual.keySet();
    }

    Object[] getPropertyValue(String propertyName) {
        return this.propertiesEqual.get(propertyName);
    }
}

