/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.matching.filter;

import org.neo4j.util.matching.filter.AbstractFilterExpression;
import org.neo4j.util.matching.filter.FilterValueGetter;

public class CompareExpression
extends AbstractFilterExpression {
    private final String operator;
    private final Object compareValue;

    public CompareExpression(String label, String property, String operator, Object value) {
        super(label, property);
        this.operator = operator;
        this.compareValue = value;
    }

    public boolean matches(FilterValueGetter valueGetter) {
        for (Object value : valueGetter.getValues(this.getLabel())) {
            int comparison = 0;
            try {
                comparison = ((Comparable)value).compareTo((Comparable)this.compareValue);
            }
            catch (Exception e) {
                comparison = value.toString().compareTo(this.compareValue.toString());
            }
            boolean match = false;
            if (this.operator.equals("<")) {
                match = comparison < 0;
            } else if (this.operator.equals("<=")) {
                match = comparison <= 0;
            } else if (this.operator.equals("=")) {
                match = comparison == 0;
            } else if (this.operator.equals(">=")) {
                match = comparison >= 0;
            } else if (this.operator.equals(">")) {
                boolean bl = match = comparison > 0;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }
}

