/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.neometa.model;

import java.util.Collection;
import org.neo4j.api.core.Transaction;
import org.neo4j.neometa.model.MetaModel;
import org.neo4j.neometa.model.MetaModelImpl;
import org.neo4j.neometa.model.MetaObject;
import org.neo4j.neometa.model.MetaObjectCollection;
import org.neo4j.neometa.model.MetaProperty;
import org.neo4j.neometa.structure.MetaStructureClass;
import org.neo4j.neometa.structure.MetaStructureProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaClass
extends MetaObject<MetaStructureClass> {
    MetaClass(MetaModel model, MetaStructureClass metaClass) {
        super(model, metaClass);
    }

    public Collection<MetaClass> getDirectSuperClasses() {
        return new MetaObjectCollection.MetaClassCollection(this.model(), ((MetaStructureClass)this.getThing()).getDirectSupers());
    }

    public Collection<MetaClass> getDirectSubClasses() {
        return new MetaObjectCollection.MetaClassCollection(this.model(), ((MetaStructureClass)this.getThing()).getDirectSubs());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaProperty getDeclaredProperty(String name, boolean allowCreate) {
        Transaction tx = this.neo().beginTx();
        try {
            MetaStructureProperty metaProperty = ((MetaModelImpl)this.model()).meta().getNamespace(this.getName(), true).getMetaProperty(name, allowCreate);
            if (allowCreate) {
                ((MetaStructureClass)this.getThing()).getDirectProperties().add(metaProperty);
            }
            MetaProperty result = metaProperty == null ? null : new MetaProperty(this.model(), metaProperty);
            tx.success();
            MetaProperty metaProperty2 = result;
            return metaProperty2;
        }
        finally {
            tx.finish();
        }
    }

    public Collection<MetaProperty> getDeclaredProperties() {
        return new MetaObjectCollection.MetaPropertyCollection(this.model(), ((MetaStructureClass)this.getThing()).getDirectProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaProperty getProperty(String name, boolean allowCreate) {
        Transaction tx = this.neo().beginTx();
        try {
            MetaProperty result = this.getDeclaredProperty(name, false);
            if (result == null) {
                for (MetaClass cls : this.getDirectSuperClasses()) {
                    MetaProperty property = cls.getProperty(name, false);
                    if (property == null) continue;
                    result = property;
                    break;
                }
            }
            if (result == null && allowCreate) {
                result = this.getDeclaredProperty(name, allowCreate);
            }
            tx.success();
            MetaProperty metaProperty = result;
            return metaProperty;
        }
        finally {
            tx.finish();
        }
    }

    public Collection<MetaProperty> getProperties() {
        return new MetaObjectCollection.MetaPropertyCollection(this.model(), ((MetaStructureClass)this.getThing()).getAllProperties());
    }
}

