/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.neometa.model;

import java.util.Collection;
import org.neo4j.commons.iterator.CollectionWrapper;
import org.neo4j.neometa.model.MetaClass;
import org.neo4j.neometa.model.MetaModel;
import org.neo4j.neometa.model.MetaObject;
import org.neo4j.neometa.model.MetaProperty;
import org.neo4j.neometa.structure.MetaStructureClass;
import org.neo4j.neometa.structure.MetaStructureProperty;
import org.neo4j.neometa.structure.MetaStructureThing;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MetaObjectCollection<T extends MetaObject<U>, U extends MetaStructureThing>
extends CollectionWrapper<T, U> {
    private MetaModel model;

    MetaObjectCollection(MetaModel model, Collection<U> collection) {
        super(collection);
        this.model = model;
    }

    protected MetaModel model() {
        return this.model;
    }

    protected U objectToUnderlyingObject(T object) {
        return (U)((MetaObject)object).getThing();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MetaPropertyCollection
    extends MetaObjectCollection<MetaProperty, MetaStructureProperty> {
        MetaPropertyCollection(MetaModel model, Collection<MetaStructureProperty> collection) {
            super(model, collection);
        }

        protected MetaProperty underlyingObjectToObject(MetaStructureProperty object) {
            return new MetaProperty(this.model(), object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MetaClassCollection
    extends MetaObjectCollection<MetaClass, MetaStructureClass> {
        MetaClassCollection(MetaModel model, Collection<MetaStructureClass> collection) {
            super(model, collection);
        }

        protected MetaClass underlyingObjectToObject(MetaStructureClass object) {
            return new MetaClass(this.model(), object);
        }
    }
}

