/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.neometa.structure;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.neo4j.neometa.structure.MetaStructureRestrictable;
import org.neo4j.neometa.structure.RdfDatatypeRange;
import org.neo4j.neometa.structure.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataRange
extends RdfDatatypeRange {
    private static final String KEY_DATA_ARRAY = "data_array";
    private Collection<Object> values;

    public DataRange(String datatype, Object ... values) {
        super(datatype);
        this.values = new HashSet<Object>(Arrays.asList(values));
    }

    public DataRange() {
    }

    public Collection<Object> getValues() {
        return Collections.unmodifiableCollection(this.values);
    }

    @Override
    protected void internalLoad(MetaStructureRestrictable owner) {
        super.internalLoad(owner);
        String[] dataArray = (String[])owner.node().getProperty(KEY_DATA_ARRAY, (Object)new String[0]);
        this.values = new HashSet<Object>();
        for (String value : dataArray) {
            try {
                this.values.add(this.rdfLiteralToJavaObject(value));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected void internalStore(MetaStructureRestrictable owner) {
        super.internalStore(owner);
        String[] dataArray = new String[this.values.size()];
        int i = 0;
        for (Object value : this.values) {
            dataArray[i++] = this.javaObjectToRdfLiteral(value);
        }
        owner.node().setProperty(KEY_DATA_ARRAY, (Object)dataArray);
    }

    @Override
    protected void internalRemove(MetaStructureRestrictable owner) {
        super.internalRemove(owner);
        owner.node().removeProperty(KEY_DATA_ARRAY);
    }

    @Override
    public boolean isDatatype() {
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getRdfDatatype() + ": " + StringUtil.join(", ", this.getValues().toArray()) + "]";
    }
}

