/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.neometa.structure;

import org.neo4j.neometa.structure.MetaStructureRestrictable;
import org.neo4j.neometa.structure.SimpleStringPropertyRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatatypeClassRange
extends SimpleStringPropertyRange {
    private Class<?> rangeClass;

    public DatatypeClassRange(Class<?> rangeClass) {
        this.rangeClass = rangeClass;
    }

    public DatatypeClassRange() {
    }

    public Class<?> getRangeClass() {
        return this.rangeClass;
    }

    @Override
    protected String toStringRepresentation(MetaStructureRestrictable owner) {
        return this.rangeClass.getName();
    }

    @Override
    protected void fromStringRepresentation(MetaStructureRestrictable owner, String stringRepresentation) {
        try {
            this.rangeClass = Class.forName(stringRepresentation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object rdfLiteralToJavaObject(String value) {
        String result = null;
        if (this.rangeClass.equals(String.class)) {
            result = value;
        } else {
            try {
                result = this.rangeClass.getConstructor(String.class).newInstance(value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public String javaObjectToRdfLiteral(Object value) {
        return value.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.rangeClass.getName() + "]";
    }
}

