/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.neometa.structure;

import org.neo4j.neometa.structure.LookerUpper;
import org.neo4j.neometa.structure.MetaStructureClass;
import org.neo4j.neometa.structure.MetaStructureProperty;
import org.neo4j.neometa.structure.MetaStructureRestriction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class LookupUtil {
    LookupUtil() {
    }

    static <T> T lookup(MetaStructureProperty property, LookerUpper<T> finder, MetaStructureClass ... inTheseClasses) {
        T result = null;
        for (MetaStructureClass cls : inTheseClasses) {
            T value = LookupUtil.tryLookupFromRestrictions(property, finder, cls);
            if (value == null) continue;
            result = value;
            break;
        }
        if (result == null) {
            result = LookupUtil.tryLookupFromProperty(property, finder);
        }
        return result;
    }

    private static <T> T tryLookupFromProperty(MetaStructureProperty property, LookerUpper<T> finder) {
        T value = finder.get(property);
        if (value != null) {
            return value;
        }
        for (MetaStructureProperty superProperty : property.getDirectSupers()) {
            value = LookupUtil.tryLookupFromProperty(superProperty, finder);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private static <T> T tryLookupFromRestrictions(MetaStructureProperty property, LookerUpper<T> finder, MetaStructureClass cls) {
        T value;
        MetaStructureRestriction restriction = cls.getRestriction(property, false);
        if (restriction != null && (value = finder.get(restriction)) != null) {
            return value;
        }
        for (MetaStructureClass superClass : cls.getDirectSupers()) {
            T value2 = LookupUtil.tryLookupFromRestrictions(property, finder, superClass);
            if (value2 == null) continue;
            return value2;
        }
        return null;
    }
}

