/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.neometa.structure;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.Node;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.api.core.ReturnableEvaluator;
import org.neo4j.api.core.StopEvaluator;
import org.neo4j.api.core.Transaction;
import org.neo4j.api.core.TraversalPosition;
import org.neo4j.api.core.Traverser;
import org.neo4j.neometa.structure.MetaStructure;
import org.neo4j.neometa.structure.MetaStructureInstanceCollection;
import org.neo4j.neometa.structure.MetaStructureObjectCollection;
import org.neo4j.neometa.structure.MetaStructureProperty;
import org.neo4j.neometa.structure.MetaStructureRelTypes;
import org.neo4j.neometa.structure.MetaStructureRestriction;
import org.neo4j.neometa.structure.MetaStructureThing;
import org.neo4j.util.OneOfRelTypesReturnableEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaStructureClass
extends MetaStructureThing {
    public MetaStructureClass(MetaStructure meta, Node node) {
        super(meta, node);
    }

    private Collection<MetaStructureClass> hierarchyCollection(Direction direction) {
        return new MetaStructureObjectCollection<MetaStructureClass>(this.neo(), this.node(), MetaStructureRelTypes.META_IS_SUBCLASS_OF, direction, this.meta(), MetaStructureClass.class);
    }

    public Collection<MetaStructureClass> getDirectSubs() {
        return this.hierarchyCollection(Direction.INCOMING);
    }

    public Collection<MetaStructureClass> getDirectSupers() {
        return this.hierarchyCollection(Direction.OUTGOING);
    }

    @Override
    protected RelationshipType subRelationshipType() {
        return MetaStructureRelTypes.META_IS_SUBCLASS_OF;
    }

    public Collection<MetaStructureProperty> getDirectProperties() {
        return new MetaStructureObjectCollection<MetaStructureProperty>(this.neo(), this.node(), MetaStructureRelTypes.META_CLASS_HAS_PROPERTY, Direction.OUTGOING, this.meta(), MetaStructureProperty.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<MetaStructureProperty> getAllProperties() {
        Transaction tx = this.neo().beginTx();
        try {
            HashSet<MetaStructureProperty> properties = new HashSet<MetaStructureProperty>();
            for (Node node : this.node().traverse(Traverser.Order.BREADTH_FIRST, StopEvaluator.END_OF_NETWORK, (ReturnableEvaluator)new AllPropertiesRE(), new Object[]{MetaStructureRelTypes.META_IS_SUBPROPERTY_OF, Direction.INCOMING, MetaStructureRelTypes.META_CLASS_HAS_PROPERTY, Direction.OUTGOING, MetaStructureRelTypes.META_IS_SUBCLASS_OF, Direction.OUTGOING})) {
                properties.add(new MetaStructureProperty(this.meta(), node));
            }
            Set<MetaStructureProperty> set = Collections.unmodifiableSet(properties);
            return set;
        }
        finally {
            tx.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaStructureRestriction getRestriction(MetaStructureProperty property, boolean allowCreate) {
        Transaction tx = this.neo().beginTx();
        try {
            Collection<MetaStructureRestriction> restrictions = this.getDirectRestrictions();
            for (MetaStructureRestriction restriction : restrictions) {
                if (!restriction.getMetaProperty().equals(property)) continue;
                MetaStructureRestriction metaStructureRestriction = restriction;
                return metaStructureRestriction;
            }
            if (!allowCreate) {
                Iterator<MetaStructureRestriction> i$ = null;
                return i$;
            }
            if (!this.getAllProperties().contains(property)) {
                throw new RuntimeException(this + " isn't in the domain of " + property + " add it first");
            }
            Node node = this.neo().createNode();
            MetaStructureRestriction result = new MetaStructureRestriction(this.meta(), node);
            restrictions.add(result);
            node.createRelationshipTo(property.node(), (RelationshipType)MetaStructureRelTypes.META_RESTRICTION_TO_PROPERTY);
            tx.success();
            MetaStructureRestriction metaStructureRestriction = result;
            return metaStructureRestriction;
        }
        finally {
            tx.finish();
        }
    }

    public Collection<MetaStructureRestriction> getDirectRestrictions() {
        return new MetaStructureObjectCollection<MetaStructureRestriction>(this.neo(), this.node(), MetaStructureRelTypes.META_RESTRICTION_TO_CLASS, Direction.INCOMING, this.meta(), MetaStructureRestriction.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<MetaStructureRestriction> getAllRestrictions() {
        Transaction tx = this.neo().beginTx();
        try {
            HashSet<MetaStructureRestriction> restrictions = new HashSet<MetaStructureRestriction>();
            for (Node node : this.node().traverse(Traverser.Order.BREADTH_FIRST, StopEvaluator.END_OF_NETWORK, (ReturnableEvaluator)new OneOfRelTypesReturnableEvaluator(new RelationshipType[]{MetaStructureRelTypes.META_RESTRICTION_TO_CLASS}), (RelationshipType)MetaStructureRelTypes.META_RESTRICTION_TO_CLASS, Direction.INCOMING, (RelationshipType)MetaStructureRelTypes.META_IS_SUBCLASS_OF, Direction.OUTGOING)) {
                restrictions.add(new MetaStructureRestriction(this.meta(), node));
            }
            Set<MetaStructureRestriction> set = Collections.unmodifiableSet(restrictions);
            return set;
        }
        finally {
            tx.finish();
        }
    }

    public Collection<Node> getInstances() {
        return new MetaStructureInstanceCollection(this.neo(), this.node(), this.meta());
    }

    private class AllPropertiesRE
    implements ReturnableEvaluator {
        private AllPropertiesRE() {
        }

        private boolean same(RelationshipType r1, RelationshipType r2) {
            return r1.name().equals(r2.name());
        }

        public boolean isReturnableNode(TraversalPosition currentPos) {
            Relationship lastRel = currentPos.lastRelationshipTraversed();
            if (lastRel == null || this.same(lastRel.getType(), MetaStructureRelTypes.META_IS_SUBCLASS_OF)) {
                return false;
            }
            return !this.same(lastRel.getType(), MetaStructureRelTypes.META_IS_SUBPROPERTY_OF) || !currentPos.currentNode().hasRelationship(new RelationshipType[]{MetaStructureRelTypes.META_CLASS_HAS_PROPERTY});
        }
    }
}

