/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.neometa.structure;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.api.core.Direction;
import org.neo4j.api.core.Relationship;
import org.neo4j.api.core.RelationshipType;
import org.neo4j.neometa.structure.MetaStructureClass;
import org.neo4j.neometa.structure.MetaStructureImpl;
import org.neo4j.neometa.structure.MetaStructureRelTypes;
import org.neo4j.neometa.structure.MetaStructureRestrictable;
import org.neo4j.neometa.structure.PropertyRange;
import org.neo4j.neometa.structure.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaStructureClassRange
extends PropertyRange {
    private Set<MetaStructureClass> rangeClasses;

    public MetaStructureClassRange(MetaStructureClass ... rangeClasses) {
        this.rangeClasses = new HashSet<MetaStructureClass>(Arrays.asList(rangeClasses));
    }

    public MetaStructureClassRange() {
    }

    public MetaStructureClass[] getRangeClasses() {
        return this.rangeClasses.toArray(new MetaStructureClass[this.rangeClasses.size()]);
    }

    public RelationshipType getRelationshipTypeToUse() {
        return ((MetaStructureImpl)this.getOwner().meta()).dynamicRelTypes().getOrCreateType(this.getOwner().getName());
    }

    @Override
    protected void internalStore(MetaStructureRestrictable owner) {
        for (MetaStructureClass cls : this.rangeClasses) {
            owner.node().createRelationshipTo(cls.node(), (RelationshipType)MetaStructureRelTypes.META_PROPERTY_HAS_RANGE);
        }
    }

    private Iterable<Relationship> getRelationships(MetaStructureRestrictable owner) {
        return owner.node().getRelationships((RelationshipType)MetaStructureRelTypes.META_PROPERTY_HAS_RANGE, Direction.OUTGOING);
    }

    @Override
    protected void internalLoad(MetaStructureRestrictable owner) {
        this.rangeClasses = new HashSet<MetaStructureClass>();
        for (Relationship rel : this.getRelationships(owner)) {
            this.rangeClasses.add(new MetaStructureClass(owner.meta(), rel.getEndNode()));
        }
    }

    @Override
    protected void internalRemove(MetaStructureRestrictable owner) {
        for (Relationship rel : this.getRelationships(owner)) {
            rel.delete();
        }
    }

    @Override
    public Object rdfLiteralToJavaObject(String value) {
        throw new UnsupportedOperationException("Should never be called");
    }

    @Override
    public String javaObjectToRdfLiteral(Object value) {
        throw new UnsupportedOperationException("Should never be called");
    }

    @Override
    public boolean isDatatype() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + StringUtil.join(", ", this.rangeClasses.toArray(new MetaStructureClass[this.rangeClasses.size()])) + "]";
    }
}

